/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;

public class Export<E> {
    private static final Log log = LogFactory.getLog(Export.class);
    protected ExportModel<E> model;
    protected Collection<E> data;

    public static <E> Export<E> newExport(ExportModel<E> model, Collection<E> data) {
        return new Export<E>(model, data);
    }

    protected Export(ExportModel<E> model, Collection<E> data) {
        this.model = model;
        this.data = data;
    }

    public String startExportAsString() throws Exception {
        String separator = String.valueOf(this.model.getSeparator());
        StringBuilder csv = new StringBuilder();
        LinkedList<String> headerNames = new LinkedList<String>();
        for (ExportableColumn<E, Object> column : this.model.getColumnsForExport()) {
            headerNames.add(column.getHeaderName());
        }
        String headersLine = StringUtil.join(headerNames, (String)separator, (boolean)true);
        csv.append(headersLine).append('\n');
        if (log.isDebugEnabled()) {
            log.debug((Object)("headers for export are '" + headersLine + "'"));
            log.debug((Object)("will export " + this.data.size() + " lines"));
        }
        Collection<ExportableColumn<E, Object>> columnsForExport = this.model.getColumnsForExport();
        for (E object : this.data) {
            for (ExportableColumn<E, Object> column : columnsForExport) {
                Object value;
                String formattedValue = column.formatValue(value = column.getValue(object));
                if (formattedValue == null) {
                    throw new NullPointerException("column for header " + column.getHeaderName() + " returned a null value." + column.toString());
                }
                formattedValue = StringUtil.escapeCsvValue((String)formattedValue, (String)separator);
                csv.append(formattedValue).append(separator);
            }
            csv.append('\n');
        }
        return csv.toString();
    }

    public InputStream startExport() throws Exception {
        String content = this.startExportAsString();
        return IOUtils.toInputStream((String)content);
    }
}

