/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin;

import com.google.common.base.Joiner;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

class ReportRenderer
extends AbstractMavenReportRenderer {
    private final I18N i18n;
    private final Locale locale;
    private final String reportName;
    private final String bundleName;
    private final Set<ApplicationConfigProvider> configProviders;

    ReportRenderer(Sink sink, I18N i18n, Locale locale, String reportName, String bundleName, Set<ApplicationConfigProvider> configProviders) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.reportName = reportName;
        this.bundleName = bundleName;
        this.sink = sink;
        this.configProviders = configProviders;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.lineBreak();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.link("http://nuiton-config.nuiton.org/v/latest/index.html");
        this.sink.text(this.getText("report.overview.more.information"));
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.lineBreak();
        this.renderProviderSummaryTable();
        this.sink.section1_();
        if (CollectionUtils.isNotEmpty(this.configProviders)) {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.getText("report.detail.title"));
            this.sink.sectionTitle1_();
            this.sink.lineBreak();
            this.sink.paragraph();
            this.sink.text(this.getText("report.detail.text"));
            this.sink.paragraph_();
            for (ApplicationConfigProvider configProvider : this.configProviders) {
                this.renderConfigProviderDetail(configProvider);
            }
            this.sink.section1_();
        }
    }

    private void renderProviderSummaryTable() {
        if (CollectionUtils.isEmpty(this.configProviders)) {
            this.sink.text(this.getText("report.detail.text.noConfig"));
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.name"));
            this.sinkHeaderCellText(this.getText("report.config.description"));
            this.sinkHeaderCellText(this.getText("report.config.nbOptions"));
            this.sinkHeaderCellText(this.getText("report.config.nbActions"));
            this.sink.tableRow_();
            for (ApplicationConfigProvider configProvider : this.configProviders) {
                this.sink.tableRow();
                this.sinkCellLink(configProvider.getName(), "detail_" + configProvider.getName());
                this.sinkCellText(configProvider.getDescription(this.locale));
                this.sinkCellText(configProvider.getOptions().length + "");
                this.sinkCellText(configProvider.getActions().length + "");
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    private void renderConfigProviderDetail(ApplicationConfigProvider configProvider) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.anchor("detail_" + configProvider.getName());
        this.sink.text(this.getText("report.detail.configuration.title") + "   " + configProvider.getName());
        this.sink.anchor_();
        this.sink.sectionTitle2_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.config.name") + " : ");
        this.sink.bold();
        this.sink.text(configProvider.getName());
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.config.description") + " : ");
        this.sink.bold();
        this.sink.text(configProvider.getDescription(this.locale));
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.anchor("detail_options_" + configProvider.getName());
        this.sink.text(this.getText("report.detail.options.title"));
        this.sink.anchor_();
        this.sink.sectionTitle3_();
        this.sink.lineBreak();
        this.renderOptionDefsTable(configProvider.getOptions());
        this.sink.section3_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.anchor("detail_actions_" + configProvider.getName());
        this.sink.text(this.getText("report.detail.actions.title"));
        this.sink.anchor_();
        this.sink.sectionTitle3_();
        this.sink.lineBreak();
        this.renderActionDefsTable(configProvider.getActions());
        this.sink.section3_();
        this.sink.section2_();
    }

    private void renderOptionDefsTable(ConfigOptionDef ... options) {
        if (options.length == 0) {
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(this.getText("report.detail.options.noOptions"));
            this.sink.bold_();
            this.sink.paragraph_();
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.option.key"));
            this.sinkHeaderCellText(this.getText("report.config.option.description"));
            this.sinkHeaderCellText(this.getText("report.config.option.defaultValue"));
            this.sinkHeaderCellText(this.getText("report.config.option.final"));
            this.sinkHeaderCellText(this.getText("report.config.option.transient"));
            this.sinkHeaderCellText(this.getText("report.config.option.type"));
            this.sink.tableRow_();
            for (ConfigOptionDef option : options) {
                this.sink.tableRow();
                this.sinkCellText(option.getKey());
                this.sinkCellText(I18n.l((Locale)this.locale, (String)option.getDescription(), (Object[])new Object[0]));
                this.sinkCellVerbatimText(this.getDefaultValue(option));
                this.sinkCellText(this.getText(!option.isFinal()));
                this.sinkCellText(this.getText(!option.isTransient()));
                this.sinkCellVerbatimText(option.getType().getName());
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    private void renderActionDefsTable(ConfigActionDef ... actions) {
        if (actions.length == 0) {
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(this.getText("report.detail.actions.noActions"));
            this.sink.bold_();
            this.sink.paragraph_();
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.action.description"));
            this.sinkHeaderCellText(this.getText("report.config.action.aliases"));
            this.sinkHeaderCellText(this.getText("report.config.action.action"));
            this.sink.tableRow_();
            for (ConfigActionDef action : actions) {
                this.sink.tableRow();
                this.sinkCellText(I18n.l((Locale)this.locale, (String)action.getDescription(), (Object[])new Object[0]));
                this.sinkCellText(Joiner.on((String)",").join((Object[])action.getAliases()));
                this.sinkCellText(action.getAction());
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    private String getText(boolean key) {
        return this.getText("report." + String.valueOf(key));
    }

    private String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    private String getDefaultValue(ConfigOptionDef option) {
        String defaultValue = option.getDefaultValue();
        if (StringUtils.isBlank((String)defaultValue)) {
            defaultValue = this.getText("report.noDefaultValue");
        }
        return defaultValue;
    }

    private void sinkHeaderCellText(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    private void sinkCellText(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    private void sinkCellVerbatimText(String text) {
        this.sink.tableCell();
        this.sink.verbatim(SinkEventAttributeSet.MONOSPACED);
        this.sink.text(text);
        this.sink.verbatim_();
        this.sink.tableCell_();
    }

    private void sinkCellLink(String text, String url) {
        this.sink.tableCell();
        this.sinkLinkToAnchor(text, url);
        this.sink.tableCell_();
    }

    private void sinkLinkToAnchor(String text, String anchor) {
        this.sink.link("./" + this.reportName + ".html#" + anchor);
        this.sink.text(text);
        this.sink.link_();
    }
}

