/*
 * #%L
 * Maven Nuiton Skin
 * 
 * $Id: ScmwebeditorUtils.java 641 2011-08-19 15:04:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-nuiton-skin/tags/maven-nuiton-skin-1.1/src/main/java/org/nuiton/maven/skin/ScmwebeditorUtils.java $
 * %%
 * Copyright (C) 2006 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.maven.skin;

import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.logging.Logger;

import java.io.File;
import java.util.List;
import java.util.Locale;

/**
 * A tool to be used in the velocity template.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.6
 */
public class ScmwebeditorUtils {

    private Logger logger;

    private VelocityContext context;

    private List<Locale> locales;

    private Locale locale;

    private String scmwebeditorURL;

    private String siteXmlScmwebeditorURL;

    private String siteSourcesType;

    private MavenProject mavenProject;

    public ScmwebeditorUtils(VelocityContext context, Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setScmwebeditorURL(String scmwebeditorURL) {
        this.scmwebeditorURL = scmwebeditorURL;
    }

    public void setSiteSourcesType(String siteSourcesType) {
        this.siteSourcesType = siteSourcesType;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setSiteXmlScmwebeditorURL(String siteXmlScmwebeditorURL) {
        this.siteXmlScmwebeditorURL = siteXmlScmwebeditorURL;
    }

    public String getSiteXmlScmwebeditorURL() {
        return siteXmlScmwebeditorURL;
    }

    public boolean isCurrentFileEditable() {
        String editFile = getCurrentFileName();
        File file = getFile(editFile);
        getLogger().debug("[" + editFile + "] on filesystem = " + file);
        boolean exist = file.exists();
        return exist;
    }

    public String getCurrentFileScmwebeditorURL() {
        String editFile = getCurrentFileName();
        String relativePath = getRelativePath(editFile, '/');

        String result = scmwebeditorURL + relativePath;
        getLogger().debug("[" + editFile + "] scmwebeditor url = " + result);
        return result;
    }

    protected VelocityContext getContext() {
        return context;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected MavenProject getProject() {
        return mavenProject;
    }

    protected String getAlignedFileName() {
        return (String) context.get("alignedFileName");
    }

    protected String getCurrentFileName() {
        return (String) context.get("currentFileName");
    }


    protected boolean isFirstLocale() {
        return locale.equals(locales.get(0));
    }


    protected String getRelativePath(String editFile,
                                     char separator) {

        String alignedFileName = getAlignedFileName();
        int lastIndex = alignedFileName.lastIndexOf(".") + 1;
        if (lastIndex > 0) {
            editFile = editFile.substring(0, lastIndex);
        }

        String result = "src" + separator + "site" + separator;
        if (!isFirstLocale()) {
            result += locale.toString() + separator;
        }

        result += siteSourcesType + separator;
        result += editFile + siteSourcesType;
        return result;
    }

    protected File getFile(String editFile) {
        File basedir = getProject().getBasedir();

        String relativePath = getRelativePath(editFile, File.separatorChar);

        File result = new File(basedir, relativePath);
        return result;
    }

}
