/*
 * #%L
 * Maven Nuiton Skin
 * 
 * $Id: NuitonSiteRenderer.java 641 2011-08-19 15:04:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-nuiton-skin/tags/maven-nuiton-skin-1.1/src/main/java/org/nuiton/maven/skin/NuitonSiteRenderer.java $
 * %%
 * Copyright (C) 2006 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.maven.skin;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Override of the DefaultSiteRenderer to make customize the velocity context.
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: NuitonSiteRenderer.java 641 2011-08-19 15:04:21Z tchemit $
 * @plexus.component role-hint="default"
 * @since 1.0
 */
public class NuitonSiteRenderer extends DefaultSiteRenderer {

    /**
     * SiteTool.
     *
     * @component
     */
    protected SiteTool siteTool;

    // this method is the private one from super class
    protected Method createContextMethod;

    // this method is the private one from super class
    protected Method writeTemplateMethod;

    private String siteSourcesType;

    private List<Locale> locales;

    private Locale locale;

    private MavenProject mavenProject;

    private String scmwebeditorPrefixURL;

    private String siteXmlScmwebeditorURL;

    private boolean scmwebeditorEnabled;

    protected Method getWriteTemplateMethod() {
        if (writeTemplateMethod == null) {
            writeTemplateMethod = ReflectUtil.getMethod(
                    getClass().getSuperclass(),
                    "writeTemplate",
                    new Class<?>[]{
                            Writer.class,
                            Context.class,
                            SiteRenderingContext.class
                    });
        }
        getLogger();
        return writeTemplateMethod;
    }

    protected Method getCreateContextMethod() {
        if (createContextMethod == null) {
            createContextMethod = ReflectUtil.getMethod(
                    getClass().getSuperclass(),
                    "createContext",
                    new Class<?>[]{
                            SiteRendererSink.class,
                            SiteRenderingContext.class}
            );
        }
        return createContextMethod;
    }

    public void render(Collection<DocumentRenderer> documents,
                       SiteRenderingContext siteRenderingContext,
                       File outputDirectory)
            throws RendererException, IOException {

        // prepare all common values for a given module


        locale = siteRenderingContext.getLocale();

        Map<String, ?> templateProperties = siteRenderingContext.getTemplateProperties();

        String value = (String) templateProperties.get("scmwebeditorEnabled");
        scmwebeditorEnabled = StringUtils.isNotEmpty(value) && !"false".equals(value);

        if (scmwebeditorEnabled) {

            // get locales (defined in pom)
            String localesAsStr = (String) templateProperties.get("locales");

            // get locales as a list
            List<Locale> locales = siteTool.getAvailableLocales(localesAsStr);

            this.locales = locales;

            mavenProject = (MavenProject) templateProperties.get("project");
            siteSourcesType = (String) mavenProject.getProperties().get("siteSourcesType");

            String scm = mavenProject.getScm().getDeveloperConnection();
            String scmURL = scm.substring(8);

            String scmwebeditorUrl = (String) mavenProject.getProperties().get("scmwebeditorUrl");
            scmwebeditorPrefixURL = scmwebeditorUrl + "?address=" + scmURL + '/';

            getLogger().info("SCMWebeditor prefix url = " + scmwebeditorPrefixURL);

            //FIXME tchemit 2011-08-19 must test if file exists (if first locale) to respect maven
            // default loayout src/site/site.xml
            String editFile = "src/site/site_" + locale + ".xml";
            siteXmlScmwebeditorURL = scmwebeditorPrefixURL + editFile;

            getLogger().debug("[" + editFile + "] scmwebeditor url = " + siteXmlScmwebeditorURL);

        }
        super.render(documents, siteRenderingContext, outputDirectory);

    }

    @Override
    public void generateDocument(Writer writer,
                                 SiteRendererSink sink,
                                 SiteRenderingContext siteRenderingContext)
            throws RendererException {

        if (getLogger().isDebugEnabled()) {
            getLogger().debug("Will generate document " + sink.getRenderingContext().getOutputName());
        }
        Context context = createContext(sink, siteRenderingContext);

        writeTemplate(writer, context, siteRenderingContext);
    }

    protected Context createContext(SiteRendererSink sink,
                                    SiteRenderingContext siteRenderingContext) {
        Method m = getCreateContextMethod();
        VelocityContext context =
                ReflectUtil.invokeMethod(m, this, sink, siteRenderingContext);

        if (scmwebeditorEnabled) {

            // add our tool to velocity context
            
            ScmwebeditorUtils tools =
                    new ScmwebeditorUtils(context, getLogger());

            tools.setLocale(locale);
            tools.setLocales(locales);
            tools.setMavenProject(mavenProject);
            tools.setScmwebeditorURL(scmwebeditorPrefixURL);
            tools.setSiteSourcesType(siteSourcesType);
            tools.setSiteXmlScmwebeditorURL(siteXmlScmwebeditorURL);
            context.put("ScmwebeditorUtils", tools);

        }
        return context;
    }

    protected void writeTemplate(Writer writer,
                                 Context context,
                                 SiteRenderingContext siteContext)
            throws RendererException {

        Method m = getWriteTemplateMethod();
        ReflectUtil.invokeMethod(m, this, writer, context, siteContext);
    }

}