package org.nuiton.license.plugin.repository;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Model of a license definition in a license repository.
 *
 * @since 1.0.3
 */
public class LicenseDefinition {

    public static final String LICENSE_HEADER_FILE = "header.txt";
    public static final String LICENSE_CONTENT_FILE = "license.txt";
    protected URL baseURL;
    protected String name;
    protected String description;

    public LicenseDefinition(URL baseURL, String name, String description) {
        this.baseURL = baseURL;
        this.name = name;
        this.description = description;
    }

    public URL getBaseURL() {
        return baseURL;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public URL getLicenseURL() throws IOException {
        return LicenseRepository.getUrl(baseURL, LICENSE_CONTENT_FILE);
    }

    public URL getHeaderURL() throws IOException {
        return LicenseRepository.getUrl(baseURL, LICENSE_HEADER_FILE);
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("name", name);
        builder.append("description", description);
        builder.append("baseURL", baseURL);
        return builder.toString();
    }
}
