/*
 * *##% 
 * Maven License Plugin
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin.header.generator;

import org.nuiton.processor.filters.LicenseFilter;

/**
 * Le header pour les fichiers xml.
 *
 * @author chemit
 * @since 1.0.1
 *
 * @plexus.component role-hint="license-xml"
 */
public class XmlLicenseHeaderGeneratorImpl extends LicenseHeaderGenerator {

    public static final String GENERATOR_NAME = "license-xml";
    public static final String GENERATOR_DESCRIPTION = "generator with xml comment style";

    public XmlLicenseHeaderGeneratorImpl() {
        super(" ", "<!--", "-->", LicenseFilter.HEADER, LicenseFilter.FOOTER);
    }

    @Override
    public String getName() {
        return GENERATOR_NAME;
    }

    @Override
    public String getDescription() {
        return GENERATOR_DESCRIPTION;
    }
}
