/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: MailSender.java 776 2010-10-23 11:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.9/src/main/java/org/nuiton/io/mail/MailSender.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.mail;

/**
 * Defines the sender of a email.
 *
 * Note : this code was stolen in {@code maven-changes-plugin}, should thanks
 * them...
 * 
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public class MailSender {

    private String name;
    private String email;

    public MailSender() {
    }

    public MailSender(String name, String email) {
        this.name = name;
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return getName() + " (" + getEmail() + ")";
    }
}
