/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.mail;

import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.codehaus.plexus.mailsender.AbstractMailSender;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.mailsender.util.DateFormatUtils;
import org.codehaus.plexus.util.StringUtils;

public class ProjectJavamailMailSender
extends AbstractMailSender {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private Properties userProperties;
    private Properties props;

    public void initialize() {
        if (StringUtils.isEmpty((String)this.getSmtpHost())) {
            System.out.println("Error in configuration: Missing smtpHost.");
        }
        if (this.getSmtpPort() == 0) {
            this.setSmtpPort(25);
        }
        this.props = new Properties();
        this.props.put("mail.smtp.host", this.getSmtpHost());
        this.props.put("mail.smtp.port", String.valueOf(this.getSmtpPort()));
        if (this.getUsername() != null) {
            this.props.put("mail.smtp.auth", "true");
        }
        this.props.put("mail.debug", String.valueOf(this.getLogger().isDebugEnabled()));
        if (this.isSslMode()) {
            Security.addProvider((java.security.Provider)new Provider());
            this.props.put("mail.smtp.socketFactory.port", String.valueOf(this.getSmtpPort()));
            this.props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
            this.props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.userProperties != null) {
            for (String string : this.userProperties.keySet()) {
                String value = this.userProperties.getProperty(string);
                this.props.put(string, value);
            }
        }
    }

    public void send(MailMessage mail) throws MailSenderException {
        this.verify(mail);
        try {
            String address;
            Iterator i;
            int count;
            Authenticator auth = null;
            if (this.getUsername() != null) {
                auth = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ProjectJavamailMailSender.this.getUsername(), ProjectJavamailMailSender.this.getPassword());
                    }
                };
            }
            Session session = Session.getDefaultInstance((Properties)this.props, auth);
            session.setDebug(this.getLogger().isDebugEnabled());
            MimeMessage msg = new MimeMessage(session);
            InternetAddress addressFrom = new InternetAddress(mail.getFrom().getRfc2822Address());
            msg.setFrom((Address)addressFrom);
            if (mail.getToAddresses().size() > 0) {
                InternetAddress[] addressTo = new InternetAddress[mail.getToAddresses().size()];
                count = 0;
                i = mail.getToAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressTo[count++] = new InternetAddress(address);
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
            }
            if (mail.getCcAddresses().size() > 0) {
                InternetAddress[] addressCc = new InternetAddress[mail.getCcAddresses().size()];
                count = 0;
                i = mail.getCcAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressCc[count++] = new InternetAddress(address);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
            }
            if (mail.getBccAddresses().size() > 0) {
                InternetAddress[] addressBcc = new InternetAddress[mail.getBccAddresses().size()];
                count = 0;
                i = mail.getBccAddresses().iterator();
                while (i.hasNext()) {
                    address = ((MailMessage.Address)i.next()).getRfc2822Address();
                    addressBcc[count++] = new InternetAddress(address);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBcc);
            }
            msg.setSubject(mail.getSubject());
            msg.setContent((Object)mail.getContent(), mail.getContentType() == null ? "text/plain" : mail.getContentType());
            if (mail.getSendDate() != null) {
                msg.setHeader("Date", DateFormatUtils.getDateHeader((Date)mail.getSendDate()));
            } else {
                msg.setHeader("Date", DateFormatUtils.getDateHeader((Date)new Date()));
            }
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new MailSenderException("Error while sending mail.", (Throwable)e);
        }
    }
}

