/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.nuiton.io.PropertiesDateRemoveFilterStream;
import org.nuiton.plugin.PluginHelper;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = -1147150444452577558L;
    protected String encoding;
    protected boolean removeHeader;

    public SortedProperties(String encoding) {
        this(encoding, true);
    }

    public SortedProperties(String encoding, boolean removeHeader) {
        this.encoding = encoding;
        this.removeHeader = removeHeader;
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<Object> result;
        ArrayList<Object> objects = Collections.list(super.keys());
        try {
            List<String> list = PluginHelper.toGenericList(objects, String.class);
            Collections.sort(list);
            result = new Vector<String>(list);
        }
        catch (IllegalArgumentException e) {
            result = new Vector<Object>(objects);
        }
        return result.elements();
    }

    public SortedProperties load(File src) throws IOException {
        super.load(new InputStreamReader((InputStream)new FileInputStream(src), this.encoding));
        return this;
    }

    public void store(File dst) throws IOException {
        if (this.removeHeader) {
            super.store(new OutputStreamWriter((OutputStream)new PropertiesDateRemoveFilterStream(new FileOutputStream(dst)), this.encoding), null);
        } else {
            super.store(new FileOutputStream(dst), null);
        }
    }

    public void store(OutputStream dst) throws IOException {
        if (this.removeHeader) {
            super.store(new PropertiesDateRemoveFilterStream(dst), null);
        } else {
            super.store(dst, null);
        }
    }
}

