/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.nuiton.plugin.AbstractPlugin;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class ShareServerSecretPlugin
extends AbstractPlugin {
    protected MavenProject project;
    protected Settings settings;
    protected String serverId;
    private String usernameOut;
    private String passwordOut;
    private String passphraseOut;
    private String privateKeyOut;
    protected boolean verbose;
    protected SecDispatcher sec;
    private boolean exportUsername;
    private boolean exportPassword;
    private boolean exportPassphrase;
    private boolean exportPrivateKey;

    @Override
    protected boolean init() throws Exception {
        if (this.usernameOut != null && !this.usernameOut.trim().isEmpty()) {
            this.exportUsername = true;
        }
        if (this.passwordOut != null && !this.passwordOut.trim().isEmpty()) {
            this.exportPassword = true;
        }
        if (this.passphraseOut != null && !this.passphraseOut.trim().isEmpty()) {
            this.exportPassphrase = true;
        }
        if (this.privateKeyOut != null && !this.privateKeyOut.trim().isEmpty()) {
            this.exportPrivateKey = true;
        }
        if (!(this.exportUsername || this.exportPassword || this.exportPassphrase || this.exportPrivateKey)) {
            this.getLog().error((CharSequence)"Nothing to export, you should specify what to export via 'usernameOut', 'passwordOut', 'passphraseOut', 'privateKeyOut' parameters.");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        Server server = null;
        if (this.serverId != null && !this.serverId.trim().isEmpty() && (server = this.settings.getServer(this.serverId)) == null) {
            throw new MojoExecutionException("Could not find server with id '" + this.serverId + "', check your settings.xml file.");
        }
        Properties properties = this.project.getModel().getProperties();
        if (this.exportUsername) {
            String username = server.getUsername();
            username = this.sec.decrypt(username);
            this.getLog().info((CharSequence)("export server [" + this.serverId + "] username in ${" + this.usernameOut + "}"));
            properties.setProperty(this.usernameOut, username);
        }
        if (this.exportPassword) {
            String password = server.getPassword();
            password = this.sec.decrypt(password);
            this.getLog().info((CharSequence)("export server [" + this.serverId + "] password in ${" + this.passwordOut + "}"));
            properties.setProperty(this.passwordOut, password);
        }
        if (this.exportPassphrase) {
            String passphrase = server.getPassphrase();
            passphrase = this.sec.decrypt(passphrase);
            this.getLog().info((CharSequence)("export server [" + this.serverId + "] passphrase in ${" + this.passphraseOut + "}"));
            properties.setProperty(this.passphraseOut, passphrase);
        }
        if (this.exportPrivateKey) {
            String privateKey = server.getPrivateKey();
            this.getLog().info((CharSequence)("export server [" + this.serverId + "] privateKey in ${" + this.privateKeyOut + "}"));
            properties.setProperty(this.privateKeyOut, privateKey);
        }
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

