/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.nuiton.util.MirroredFileUpdater;
import org.nuiton.util.PluginHelper;

public abstract class AbstractPlugin
extends AbstractMojo {
    protected final String skipAfterInitMessage;

    protected abstract boolean ensurePackaging();

    protected abstract boolean init() throws Exception;

    protected abstract void doAction() throws Exception;

    protected AbstractPlugin(String skipAfterInitMessage) {
        this.skipAfterInitMessage = skipAfterInitMessage;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.ensurePackaging()) {
                this.getLog().info((CharSequence)("skip goal for packaging " + this.getProject().getPackaging()));
                return;
            }
            boolean canContinue = this.init();
            if (!canContinue) {
                this.getLog().info((CharSequence)this.skipAfterInitMessage);
                return;
            }
            this.doAction();
        }
        catch (Exception e) {
            throw new MojoExecutionException("could not init goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
        }
    }

    public abstract MavenProject getProject();

    public abstract void setProject(MavenProject var1);

    public abstract boolean isVerbose();

    public abstract void setVerbose(boolean var1);

    protected void copyFile(File srcFile, File destFile) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying " + srcFile.getName() + " to " + destFile));
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying from " + srcFile + " to " + destFile, e);
        }
    }

    protected void copyFile(String content, File destFile, String encoding) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying content to " + destFile));
            ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(encoding));
            RawInputStreamFacade facade = new RawInputStreamFacade((InputStream)in);
            FileUtils.copyStreamToFile((InputStreamFacade)facade, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying content to " + destFile, e);
        }
    }

    public void writeFile(File destFile, String content, String encoding) throws IOException {
        PluginHelper.write(destFile, content, encoding);
    }

    protected boolean isFileNewerThanPomFile(File f) {
        File pomFile = this.getProject().getFile();
        return f.exists() && f.lastModified() > pomFile.lastModified();
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files, MirroredFileUpdater updater) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("discovering java source files in root " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList<String> toTreate = new ArrayList<String>();
            if (updater != null) {
                updater.setSourceDirectory(f);
            }
            for (String filePath : tmp) {
                File srcFile = new File(f, filePath);
                if (updater != null && updater.isFileUpToDate(srcFile)) continue;
                toTreate.add(filePath);
            }
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    protected Map<String, String> getFilesToTreate(String[] includes, String[] excludes, File srcDir, MirroredFileUpdater updater) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        if (!srcDir.exists()) {
            return result;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("discovering files for " + srcDir));
        }
        ds.setBasedir(srcDir);
        ds.scan();
        String[] tmp = ds.getIncludedFiles();
        if (tmp.length < 1) {
            return result;
        }
        ArrayList<String> toTreate = new ArrayList<String>();
        if (updater != null) {
            updater.setSourceDirectory(srcDir);
        }
        for (String filePath : tmp) {
            File srcFile = new File(srcDir, filePath);
            File mirrorFile = updater.getMirrorFile(srcFile);
            if (updater != null && updater.isFileUpToDate(srcFile)) continue;
            result.put(filePath, mirrorFile.getAbsolutePath());
            toTreate.add(filePath);
        }
        if (toTreate.isEmpty()) {
            return result;
        }
        return result;
    }

    protected void addCompileSourceRoots(File srcDir) {
        if (!this.getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("adding source roots : " + srcDir.getPath()));
            }
            this.getProject().addCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeCompileSourceRoots(File srcDir) {
        if (this.getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("removing source roots : " + srcDir.getPath()));
            }
            this.getProject().getCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addTestCompileSourceRoots(File srcDir) {
        if (!this.getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("adding test source roots : " + srcDir.getPath()));
            }
            this.getProject().addTestCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeTestCompileSourceRoots(File srcDir) {
        if (this.getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("removing test source roots : " + srcDir.getPath()));
            }
            this.getProject().getTestCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addResourceDir(String dir) {
        boolean added = PluginHelper.addResourceDir(dir, this.getProject());
        if (added) {
            this.getLog().info((CharSequence)("add resource " + dir));
        }
    }

    protected void addTestResourceDir(String dir) {
        boolean added = PluginHelper.addTestResourceDir(dir, this.getProject());
        if (added) {
            this.getLog().info((CharSequence)("add test resource " + dir));
        }
    }

    protected URLClassLoader initClassLoader(MavenProject project, File src, boolean addSourcesToClassPath, boolean testPhase, boolean addResourcesToClassPath, boolean addCompileClassPath, boolean addProjectClassPath) throws MalformedURLException {
        URLClassLoader loader = null;
        if (project != null) {
            URLClassLoader result;
            try {
                ArrayList<URL> lUrls = new ArrayList<URL>();
                List sources = project.getCompileSourceRoots();
                if (addSourcesToClassPath) {
                    for (String source : sources) {
                        lUrls.add(new File(source).toURI().toURL());
                    }
                    if (testPhase) {
                        for (String source : project.getTestCompileSourceRoots()) {
                            lUrls.add(new File(source.toString()).toURI().toURL());
                        }
                    }
                }
                if (addResourcesToClassPath) {
                    for (String source : project.getResources()) {
                        Resource r = (Resource)source;
                        lUrls.add(new File(r.getDirectory()).toURI().toURL());
                    }
                }
                if (testPhase && addCompileClassPath && project != null) {
                    lUrls.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
                }
                if (src != null) {
                    lUrls.add(src.toURI().toURL());
                }
                if (addProjectClassPath) {
                    this.getLog().info((CharSequence)"use project compile scope class-path");
                    Set artifacts = project.getArtifacts();
                    for (Object o : artifacts) {
                        Artifact a = (Artifact)o;
                        lUrls.add(a.getFile().toURI().toURL());
                    }
                }
                result = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new RuntimeException("Can't create ClassLoader for reason " + e.getMessage(), e);
            }
            loader = result;
        } else {
            ArrayList<URL> lUrls = new ArrayList<URL>();
            if (addSourcesToClassPath) {
                lUrls.add(src.toURI().toURL());
            }
            loader = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (this.isVerbose()) {
            for (URL entry : loader.getURLs()) {
                this.getLog().info((CharSequence)("classpath : " + entry));
            }
        }
        return loader;
    }

    protected URL getTemplate(File f) throws IOException {
        URL r = null;
        r = f.exists() ? f.toURI().toURL() : ((Object)((Object)this)).getClass().getResource(f.toString());
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkResource(File f) throws IOException {
        if (!f.exists()) {
            InputStream r = null;
            try {
                r = ((Object)((Object)this)).getClass().getResourceAsStream(f.toString());
                if (r == null) {
                    throw new IOException("could not find ressource " + f);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
    }
}

