/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorIterator;

public class VectorIteratorImpl
implements VectorIterator {
    protected boolean hasExclude = false;
    protected double exclude;
    protected Vector vector;
    protected int size;
    protected int pos = -1;
    protected int nextPos = -1;

    public VectorIteratorImpl(Vector vector) {
        this.vector = vector;
        this.size = vector.size();
    }

    public VectorIteratorImpl(Vector vector, double exclude) {
        this(vector);
        this.setExclude(exclude);
    }

    @Override
    public void setExclude(double exclude) {
        this.hasExclude = true;
        this.exclude = exclude;
    }

    protected void computeNextPos() {
        if (this.nextPos <= this.pos) {
            do {
                ++this.nextPos;
            } while (this.nextPos < this.size && this.hasExclude && this.vector.getValue(this.nextPos) == this.exclude);
        }
    }

    @Override
    public boolean hasNext() {
        this.computeNextPos();
        return this.nextPos < this.size;
    }

    @Override
    public double next() {
        this.computeNextPos();
        this.pos = this.nextPos;
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.vector.getValue(this.pos);
    }

    @Override
    public void setValue(double value) {
        this.vector.setValue(this.pos, value);
    }

    @Override
    public int getPosition() {
        return this.pos;
    }
}

