/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.SemanticsDecorator;
import org.nuiton.util.HashList;

public class MatrixSemanticsDecorator
implements MatrixND {
    private static Log log = LogFactory.getLog(MatrixSemanticsDecorator.class);
    protected MatrixND matrix;
    protected SemanticsDecorator decorator;
    protected List[] cacheSemantics;

    public MatrixSemanticsDecorator(MatrixND matrix, SemanticsDecorator decorator) {
        this.matrix = matrix;
        this.decorator = decorator;
        this.cacheSemantics = new ArrayList[matrix.getDimCount()];
    }

    @Override
    public int getNumberOfAssignedValue() {
        return this.matrix.getNumberOfAssignedValue();
    }

    protected MatrixND wrap(MatrixND m) {
        return new MatrixSemanticsDecorator(m, this.decorator);
    }

    public String toString() {
        return this.matrix.toString();
    }

    @Override
    public MatrixFactory getFactory() {
        return this.matrix.getFactory();
    }

    @Override
    public List<?>[] getSemantics() {
        int maxi = this.cacheSemantics.length;
        for (int i = 0; i < maxi; ++i) {
            if (this.cacheSemantics[i] != null) continue;
            this.getSemantic(i);
        }
        return this.cacheSemantics;
    }

    @Override
    public List<?> getSemantics(int dim) {
        return this.getSemantic(dim);
    }

    @Override
    public List<?> getSemantic(int dim) {
        List result = this.cacheSemantics[dim];
        if (result == null) {
            List<?> tmp = this.matrix.getSemantic(dim);
            this.cacheSemantics[dim] = result = new HashList(tmp.size());
            for (Object o : tmp) {
                o = this.decorator.decorate(o);
                result.add(o);
            }
        }
        return result;
    }

    @Override
    public <E> void setSemantics(int dim, List<E> sem) {
        this.setSemantic(dim, sem);
    }

    @Override
    public <E> void setSemantic(int dim, List<E> sem) {
        this.cacheSemantics[dim] = null;
        ArrayList<E> undecorate = new ArrayList<E>(sem.size());
        for (Object o : sem) {
            o = this.decorator.undecorate(o);
            undecorate.add(o);
        }
        this.matrix.setSemantic(dim, undecorate);
    }

    @Override
    public void setName(String name) {
        this.matrix.setName(name);
    }

    @Override
    public String getName() {
        return this.matrix.getName();
    }

    @Override
    public void setDimensionName(String[] names) {
        this.matrix.setDimensionName(names);
    }

    @Override
    public void setDimensionNames(String[] names) {
        this.matrix.setDimensionNames(names);
    }

    @Override
    public String[] getDimensionName() {
        return this.matrix.getDimensionName();
    }

    @Override
    public String[] getDimensionNames() {
        return this.matrix.getDimensionNames();
    }

    @Override
    public void setDimensionName(int dim, String name) {
        this.matrix.setDimensionName(dim, name);
    }

    @Override
    public String getDimensionName(int dim) {
        return this.matrix.getDimensionName(dim);
    }

    @Override
    public double getMaxOccurence() {
        return this.matrix.getMaxOccurence();
    }

    @Override
    public double getMaxOccurrence() {
        return this.matrix.getMaxOccurrence();
    }

    @Override
    public int getNbDim() {
        return this.matrix.getNbDim();
    }

    @Override
    public int getDimCount() {
        return this.matrix.getDimCount();
    }

    @Override
    public int[] getDim() {
        return this.matrix.getDim();
    }

    @Override
    public int getDim(int d) {
        return this.matrix.getDim(d);
    }

    @Override
    public int size() {
        return this.matrix.size();
    }

    @Override
    public MatrixIterator iterator() {
        return new SemanticsDecoratorMatrixIterator(this, this.decorator, this.matrix.iterator());
    }

    @Override
    public MatrixIterator iteratorNotZero() {
        return new SemanticsDecoratorMatrixIterator(this, this.decorator, this.matrix.iteratorNotZero());
    }

    @Override
    public MatrixND map(MapFunction f) {
        return this.wrap(this.matrix.map(f));
    }

    @Override
    public double getValue(int[] dimensions) {
        return this.matrix.getValue(dimensions);
    }

    @Override
    public double getValue(int x) {
        return this.matrix.getValue(x);
    }

    @Override
    public double getValue(int x, int y) {
        return this.matrix.getValue(x, y);
    }

    @Override
    public double getValue(int x, int y, int z) {
        return this.matrix.getValue(x, y, z);
    }

    @Override
    public double getValue(int x, int y, int z, int t) {
        return this.matrix.getValue(x, y, z, t);
    }

    @Override
    public double getValue(Object[] coordinates) {
        Object[] tmp = new Object[coordinates.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.decorator.undecorate(coordinates[i]);
        }
        return this.matrix.getValue(tmp);
    }

    @Override
    public double getValue(Object x) {
        return this.matrix.getValue(this.decorator.undecorate(x));
    }

    @Override
    public double getValue(Object x, Object y) {
        return this.matrix.getValue(this.decorator.undecorate(x), this.decorator.undecorate(y));
    }

    @Override
    public double getValue(Object x, Object y, Object z) {
        return this.matrix.getValue(this.decorator.undecorate(x), this.decorator.undecorate(y), this.decorator.undecorate(z));
    }

    @Override
    public double getValue(Object x, Object y, Object z, Object t) {
        return this.matrix.getValue(this.decorator.undecorate(x), this.decorator.undecorate(y), this.decorator.undecorate(z), this.decorator.undecorate(t));
    }

    @Override
    public void setValue(int[] dimensions, double d) {
        this.matrix.setValue(dimensions, d);
    }

    @Override
    public void setValue(int x, double d) {
        this.matrix.setValue(x, d);
    }

    @Override
    public void setValue(int x, int y, double d) {
        this.matrix.setValue(x, y, d);
    }

    @Override
    public void setValue(int x, int y, int z, double d) {
        this.matrix.setValue(x, y, z, d);
    }

    @Override
    public void setValue(int x, int y, int z, int t, double d) {
        this.matrix.setValue(x, y, z, t, d);
    }

    @Override
    public void setValue(Object[] coordinates, double d) {
        Object[] tmp = new Object[coordinates.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.decorator.undecorate(coordinates[i]);
        }
        this.matrix.setValue(tmp, d);
    }

    @Override
    public void setValue(Object x, double d) {
        this.matrix.setValue(this.decorator.undecorate(x), d);
    }

    @Override
    public void setValue(Object x, Object y, double d) {
        this.matrix.setValue(this.decorator.undecorate(x), this.decorator.undecorate(y), d);
    }

    @Override
    public void setValue(Object x, Object y, Object z, double d) {
        this.matrix.setValue(this.decorator.undecorate(x), this.decorator.undecorate(y), this.decorator.undecorate(z), d);
    }

    @Override
    public void setValue(Object x, Object y, Object z, Object t, double d) {
        this.matrix.setValue(this.decorator.undecorate(x), this.decorator.undecorate(y), this.decorator.undecorate(z), this.decorator.undecorate(t), d);
    }

    @Override
    public MatrixND copy() {
        return this.wrap(this.matrix.copy());
    }

    @Override
    public MatrixND clone() {
        return this.wrap(this.matrix.clone());
    }

    @Override
    public double sumAll() {
        return this.matrix.sumAll();
    }

    @Override
    public MatrixND sumOverDim(int dim) {
        MatrixND tmp = this.matrix.sumOverDim(dim);
        MatrixND result = this.wrap(tmp);
        result.setSemantic(dim, tmp.getSemantic(dim));
        return result;
    }

    @Override
    public MatrixND sumOverDim(int dim, int step) {
        MatrixND tmp = this.matrix.sumOverDim(dim, step);
        MatrixND result = this.wrap(tmp);
        result.setSemantic(dim, tmp.getSemantic(dim));
        return result;
    }

    @Override
    public MatrixND sumOverDim(int dim, int start, int nb) {
        MatrixND tmp = this.matrix.sumOverDim(dim, start, nb);
        MatrixND result = this.wrap(tmp);
        result.setSemantic(dim, tmp.getSemantic(dim));
        return result;
    }

    @Override
    public double meanAll() {
        return this.matrix.meanAll();
    }

    @Override
    public MatrixND meanOverDim(int dim) {
        MatrixND tmp = this.matrix.meanOverDim(dim);
        MatrixND result = this.wrap(tmp);
        result.setSemantic(dim, tmp.getSemantic(dim));
        return result;
    }

    @Override
    public MatrixND meanOverDim(int dim, int step) {
        MatrixND tmp = this.matrix.meanOverDim(dim, step);
        MatrixND result = this.wrap(tmp);
        result.setSemantic(dim, tmp.getSemantic(dim));
        return result;
    }

    @Override
    public MatrixND cut(int dim, int[] toCut) {
        return this.wrap(this.matrix.cut(dim, toCut));
    }

    @Override
    public MatrixND paste(MatrixND mat) {
        this.matrix.paste(mat);
        return this;
    }

    @Override
    public MatrixND paste(int[] origin, MatrixND mat) {
        this.matrix.paste(origin, mat);
        return this;
    }

    @Override
    public MatrixND pasteSemantics(MatrixND mat) {
        if (mat != null) {
            MatrixIterator mi = mat.iterator();
            while (mi.next()) {
                Object[] sems = mi.getSemanticsCoordinates();
                if (!MatrixHelper.isValidCoordinates(this.getSemantics(), sems)) continue;
                this.setValue(sems, mi.getValue());
            }
        }
        return this;
    }

    @Override
    public MatrixND getSubMatrix(int dim, Object start, int nb) {
        start = this.decorator.undecorate(start);
        return this.wrap(this.matrix.getSubMatrix(dim, start, nb));
    }

    @Override
    public MatrixND getSubMatrix(int dim, int start, int nb) {
        return this.wrap(this.matrix.getSubMatrix(dim, start, nb));
    }

    @Override
    public MatrixND getSubMatrix(int dim, Object ... elem) {
        Object[] tmp = new Object[elem.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.decorator.undecorate(elem[i]);
        }
        return this.wrap(this.matrix.getSubMatrix(dim, tmp));
    }

    @Override
    public MatrixND getSubMatrix(int dim, int[] elem) {
        return this.wrap(this.matrix.getSubMatrix(dim, elem));
    }

    @Override
    public MatrixND getSubMatrix(Object[] ... elem) {
        Object[] tmp = new Object[elem.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.decorator.undecorate(elem[i]);
        }
        return this.wrap(this.matrix.getSubMatrix(new Object[][]{tmp}));
    }

    @Override
    public MatrixND getSubMatrix(int[] ... elems) {
        return this.wrap(this.matrix.getSubMatrix(elems));
    }

    @Override
    public MatrixND add(MatrixND m) {
        this.matrix.add(m);
        return this;
    }

    @Override
    public MatrixND minus(MatrixND m) {
        this.matrix.minus(m);
        return this;
    }

    @Override
    public MatrixND transpose() {
        return this.wrap(this.matrix.transpose());
    }

    @Override
    public MatrixND reduce() {
        return this.wrap(this.matrix.reduce());
    }

    @Override
    public MatrixND reduce(int minNbDim) {
        return this.wrap(this.matrix.reduce(minNbDim));
    }

    @Override
    public MatrixND reduceDims(int ... dims) {
        return this.wrap(this.matrix.reduceDims(dims));
    }

    @Override
    public MatrixND mult(MatrixND m) {
        this.matrix.mult(m);
        return this;
    }

    @Override
    public MatrixND mults(double d) {
        this.matrix.mults(d);
        return this;
    }

    @Override
    public MatrixND divs(double d) {
        this.matrix.divs(d);
        return this;
    }

    @Override
    public MatrixND adds(double d) {
        this.matrix.adds(d);
        return this;
    }

    @Override
    public MatrixND minuss(double d) {
        this.matrix.minuss(d);
        return this;
    }

    @Override
    public List<?> toList() {
        return this.matrix.toList();
    }

    @Override
    public void fromList(List<?> list) {
        this.matrix.fromList(list);
    }

    @Override
    public boolean isSupportedCSV() {
        return this.matrix.isSupportedCSV();
    }

    @Override
    public void importCSV(Reader reader, int[] origin) throws IOException {
        this.matrix.importCSV(reader, origin);
    }

    @Override
    public void importCSV(Reader reader, int[] origin, String matrixName) throws IOException {
        this.matrix.importCSV(reader, origin, matrixName);
    }

    @Override
    public void importCSV(File file, int[] origin) throws IOException {
        this.matrix.importCSV(file, origin);
    }

    @Override
    public void exportCSV(Writer writer, boolean withSemantics) throws IOException {
        this.matrix.exportCSV(writer, withSemantics);
    }

    @Override
    public boolean equalsValues(MatrixND mat) {
        return this.matrix.equalsValues(mat);
    }

    public static class SemanticsDecoratorMatrixIterator
    implements MatrixIterator {
        protected SemanticsDecorator decorator;
        protected MatrixIterator iterator;
        protected Object[] semArray;

        public SemanticsDecoratorMatrixIterator(MatrixND mat, SemanticsDecorator decorator, MatrixIterator iterator) {
            this.decorator = decorator;
            this.iterator = iterator;
            this.semArray = new Object[mat.getDimCount()];
        }

        @Override
        public Object[] getSemanticsCoordinates() {
            Object[] tmp = this.iterator.getSemanticsCoordinates();
            for (int i = 0; i < tmp.length; ++i) {
                this.semArray[i] = this.decorator.decorate(tmp[i]);
            }
            return this.semArray;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean next() {
            return this.iterator.next();
        }

        @Override
        public int[] getCoordinates() {
            return this.iterator.getCoordinates();
        }

        @Override
        public double getValue() {
            return this.iterator.getValue();
        }

        @Override
        public void setValue(double value) {
            this.iterator.setValue(value);
        }
    }
}

