/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.list.AbstractCollection;
import java.util.Collection;

public abstract class AbstractList
extends AbstractCollection {
    private static final long serialVersionUID = -475297140870140110L;

    protected AbstractList() {
    }

    public void addAllOf(Collection collection) {
        this.beforeInsertAllOf(this.size(), collection);
    }

    public void beforeInsertAllOf(int index, Collection collection) {
        this.beforeInsertDummies(index, collection.size());
        this.replaceFromWith(index, collection);
    }

    protected abstract void beforeInsertDummies(int var1, int var2);

    protected static void checkRange(int index, int theSize) {
        if (index >= theSize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + theSize);
        }
    }

    protected static void checkRangeFromTo(int from, int to, int theSize) {
        if (to == from - 1) {
            return;
        }
        if (from < 0 || from > to || to >= theSize) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        }
    }

    @Override
    public void clear() {
        this.removeFromTo(0, this.size() - 1);
    }

    public final void mergeSort() {
        this.mergeSortFromTo(0, this.size() - 1);
    }

    public abstract void mergeSortFromTo(int var1, int var2);

    public final void quickSort() {
        this.quickSortFromTo(0, this.size() - 1);
    }

    public abstract void quickSortFromTo(int var1, int var2);

    public void remove(int index) {
        this.removeFromTo(index, index);
    }

    public abstract void removeFromTo(int var1, int var2);

    public abstract void replaceFromWith(int var1, Collection var2);

    public abstract void reverse();

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IndexOutOfBoundsException("newSize:" + newSize);
        }
        int currentSize = this.size();
        if (newSize != currentSize) {
            if (newSize > currentSize) {
                this.beforeInsertDummies(currentSize, newSize - currentSize);
            } else if (newSize < currentSize) {
                this.removeFromTo(newSize, currentSize - 1);
            }
        }
    }

    public final void shuffle() {
        this.shuffleFromTo(0, this.size() - 1);
    }

    public abstract void shuffleFromTo(int var1, int var2);

    public final void sort() {
        this.sortFromTo(0, this.size() - 1);
    }

    public void sortFromTo(int from, int to) {
        this.quickSortFromTo(from, to);
    }

    public void trimToSize() {
    }
}

