/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.StringUtil;

public class MatrixStringEncoder {
    private static Log log = LogFactory.getLog(MatrixStringEncoder.class);

    public String getMatrixAsString(MatrixND matrix) {
        StringBuffer representationBuffer = new StringBuffer();
        representationBuffer.append("[");
        representationBuffer.append(matrix.getName());
        representationBuffer.append(",");
        representationBuffer.append(this.getDimToString(matrix.getDim()));
        representationBuffer.append(",");
        representationBuffer.append(this.getDimensionNamesToString(matrix.getDimensionNames()));
        representationBuffer.append(",");
        representationBuffer.append(this.getSemanticsToString(matrix.getSemantics()));
        representationBuffer.append(",");
        representationBuffer.append(matrix.toList().toString());
        representationBuffer.append("]");
        return representationBuffer.toString();
    }

    public MatrixND getMatrixFromString(String str) {
        MatrixND matrix = null;
        Pattern matrixPattern = Pattern.compile("^\\[(.*),(\\[.*\\]),(\\[.*\\]),(\\[.*\\]),(\\[.*\\])\\]$");
        Matcher matcher = matrixPattern.matcher(str);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Can't parse \"" + str + "\" as string");
        }
        String name = matcher.group(1);
        String dimString = matcher.group(2);
        String dimNamesString = matcher.group(3);
        String semanticsString = matcher.group(4);
        String dataString = matcher.group(5);
        int[] dim = this.getDimFromString(dimString);
        String[] dimNames = this.getDimensionNamesFromString(dimNamesString);
        List<?>[] semantics = this.getSemanticsFromString(semanticsString);
        matrix = MatrixFactory.getInstance().create(name, semantics, dimNames);
        List<?> data = MatrixHelper.convertStringToList(dataString);
        matrix.fromList(data);
        return matrix;
    }

    public String getDimToString(int[] dimArray) {
        String result = "[";
        String sep = "";
        for (int i = 0; i < dimArray.length; ++i) {
            result = result + sep + dimArray[i];
            sep = ", ";
        }
        result = result + "]";
        return result;
    }

    public int[] getDimFromString(String str) {
        String localStr = str.trim();
        if (localStr.startsWith("[") && localStr.endsWith("]")) {
            localStr = localStr.substring(1, localStr.length() - 1);
        }
        String[] dimAsString = StringUtil.split((String)localStr, (String)",");
        int[] result = new int[dimAsString.length];
        int i = 0;
        for (String dim : dimAsString) {
            int val = Integer.parseInt(dim.trim());
            result[i++] = val;
        }
        return result;
    }

    public String getDimensionNamesToString(String[] dimNamesArray) {
        String result = "[";
        String sep = "";
        for (int i = 0; i < dimNamesArray.length; ++i) {
            result = result + sep + '\"' + StringEscapeUtils.escapeJava((String)dimNamesArray[i]) + '\"';
            sep = ", ";
        }
        result = result + "]";
        return result;
    }

    public String[] getDimensionNamesFromString(String str) {
        String localStr = str.trim();
        if (localStr.startsWith("[") && localStr.endsWith("]")) {
            localStr = localStr.substring(1, localStr.length() - 1);
        }
        String[] result = StringUtil.split((String)localStr, (String)",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
            if (!result[i].startsWith("\"") || !result[i].endsWith("\"")) continue;
            String resultString = result[i].substring(1, result[i].length() - 1);
            result[i] = resultString = StringEscapeUtils.unescapeJava((String)resultString);
        }
        return result;
    }

    public String getSemanticsToString(List<?>[] semanticsArray) {
        StringBuffer result = new StringBuffer("[");
        for (int i = 0; i < semanticsArray.length; ++i) {
            result.append("[");
            List<?> semantics = semanticsArray[i];
            Iterator<?> it = semantics.iterator();
            while (it.hasNext()) {
                this.appendString(result, it.next());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("]");
            if (i + 1 >= semanticsArray.length) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    public List<?>[] getSemanticsFromString(String str) {
        String localStr = str.trim();
        if (localStr.startsWith("[") && localStr.endsWith("]")) {
            localStr = localStr.substring(1, localStr.length() - 1);
        }
        String[] sems = StringUtil.split((String)localStr, (String)",");
        List[] result = new List[sems.length];
        for (int i = 0; i < sems.length; ++i) {
            result[i] = this.splitObjects(sems[i]);
        }
        return result;
    }

    public List<?> splitObjects(String str) {
        String[] elems;
        LinkedList<Object> result = new LinkedList<Object>();
        String localStr = str.trim();
        if (localStr.startsWith("[") && localStr.endsWith("]")) {
            localStr = localStr.substring(1, localStr.length() - 1);
        }
        for (String elem : elems = StringUtil.split((String)localStr, (String)",")) {
            Object o;
            block6: {
                elem = elem.trim();
                int openbrace = elem.indexOf(40);
                String objectType = elem.substring(0, openbrace);
                String objectString = elem.substring(openbrace + 1, elem.length() - 1);
                if ("null".equals(objectType)) {
                    result.add(null);
                    continue;
                }
                ConvertUtilsBean converter = this.getConverter();
                try {
                    o = converter.convert(objectString, Class.forName(objectType));
                }
                catch (Exception e) {
                    o = objectType + "(" + objectString + ")";
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Continuing but can't convert object in matrix from String: '" + o + "'"));
                    }
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Continuing but can't convert object in matrix from String: '" + o + "'"), (Throwable)e);
                }
            }
            result.add(o);
        }
        return result;
    }

    public StringBuffer appendString(StringBuffer buffer, Object o) {
        if (o == null) {
            buffer.append("null()");
        } else {
            String qualifiedName = this.getQualifiedName(o);
            buffer.append(qualifiedName).append("(");
            ConvertUtilsBean converter = this.getConverter();
            buffer.append(converter.convert(o));
            buffer.append(")");
        }
        return buffer;
    }

    public String getQualifiedName(Object o) {
        String qualifiedName = o.getClass().getName();
        return qualifiedName;
    }

    public ConvertUtilsBean getConverter() {
        BeanUtilsBean instance = BeanUtilsBean.getInstance();
        ConvertUtilsBean cub = instance.getConvertUtils();
        return cub;
    }
}

