/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.rest;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.IOUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.RedmineTestContract;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class RedmineRestClientTest
implements RedmineTestContract {
    static RestClientConfiguration configuration;
    RedmineRestClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpClass() throws Exception {
        configuration = TestHelper.getTestConfiguration();
        RedmineRestClient client = new RedmineRestClient(configuration);
        try {
            client.open();
        }
        catch (Exception e) {
            System.out.println("could not connect to server " + configuration.getRestUrl() + ", will skip test " + RedmineRestClientTest.class.getName());
        }
        finally {
            Assume.assumeTrue((boolean)client.isOpen());
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.client = new RedmineRestClient(configuration);
        this.client.open();
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void isOpen() throws Exception {
        Assert.assertTrue((boolean)this.client.isOpen());
    }

    @Test
    public void isClose() throws Exception {
        Assert.assertTrue((boolean)this.client.isOpen());
        this.client.close();
        Assert.assertFalse((boolean)this.client.isOpen());
    }

    @Override
    @Test
    public void getProjects() throws Exception {
        this.doRequest(RedmineRestClient.GET_PROJECT_LIST, new Object[0]);
    }

    @Override
    @Test
    public void getIssuePriorities() throws Exception {
        this.doRequest(RedmineRestClient.GET_ISSUE_PRIORITY_LIST, new Object[0]);
    }

    @Override
    @Test
    public void getIssueStatuses() throws Exception {
        this.doRequest(RedmineRestClient.GET_ISSUE_STATUS_LIST, new Object[0]);
    }

    @Override
    @Test
    public void getProject() throws Exception {
        this.doRequest(RedmineRestClient.GET_PROJECT, "one");
    }

    @Override
    @Test
    public void getIssueCategories() throws Exception {
        this.doRequest(RedmineRestClient.GET_ISSUE_CATEGORY_LIST, "one");
    }

    @Override
    @Test
    public void getTrackers() throws Exception {
        this.doRequest(RedmineRestClient.GET_TRACKER_LIST, "one");
    }

    @Override
    @Test
    public void getNews() throws Exception {
        this.doRequest(RedmineRestClient.GET_NEWS_LIST, "one");
    }

    @Override
    public void getUserProjects() throws Exception {
        this.doRequest(RedmineRestClient.GET_USER_PROJECTS, "one");
    }

    @Override
    public void getProjectMembers() throws Exception {
        this.doRequest(RedmineRestClient.GET_USER_LIST, "one");
    }

    @Override
    @Test
    public void getProjectIssues() throws Exception {
        this.doRequest(RedmineRestClient.GET_PROJECT_ISSUES, "one");
    }

    @Override
    @Test
    public void getVersions() throws Exception {
        this.doRequest(RedmineRestClient.GET_VERSION_LIST, "one");
    }

    @Override
    @Test
    public void getVersion() throws Exception {
        this.doRequest(RedmineRestClient.GET_VERSION, "one", "1.0.0");
    }

    @Override
    @Test
    public void getVersionIssues() throws Exception {
        this.doRequest(RedmineRestClient.GET_ISSUE_LIST, "one", "1.0.0");
    }

    @Override
    @Test
    public void getOpenedIssues() throws Exception {
        this.doRequest(RedmineRestClient.GET_PROJECT_OPENED_ISSUES, "one");
    }

    @Override
    @Test
    public void getClosedIssues() throws Exception {
        this.doRequest(RedmineRestClient.GET_PROJECT_CLOSED_ISSUES, "one");
    }

    @Override
    @Test
    public void getIssueTimeEntries() throws Exception {
        this.doRequest(RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST, "one", "6");
    }

    @Override
    @Test
    public void getAttachments() throws Exception {
        this.doRequest(RedmineRestClient.GET_ATTACHMENTS_LIST, "one", "1.0.0");
    }

    @Override
    @Test
    public void addVersion() throws Exception {
    }

    @Override
    @Test
    public void addAttachment() throws Exception {
    }

    @Override
    @Test
    public void addNews() throws Exception {
    }

    @Override
    @Test
    public void updateVersion() throws Exception {
    }

    @Override
    @Test
    public void nextVersion() throws Exception {
    }

    @Override
    @Test
    public void addIssueTime() throws Exception {
    }

    protected void doRequest(String requestId, Object ... params) throws IOException, RestException {
        RestRequest request = this.client.getRequest(requestId, params);
        InputStream askData = this.client.askData(request);
        String toString = IOUtil.toString((InputStream)askData);
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
    }
}

