/*
 * *##% 
 * JRedmine :: Client
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.model.io.xpp3;

import java.beans.IntrospectionException;
import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.jredmine.model.Version;
import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;

/**
 * {@link Version} reader.
 * @author chemit
 * @since 1.0.0
 */
public class VersionXpp3Reader extends AbstractXpp3Reader<Version> {

    public VersionXpp3Reader() {
        super(Version.class, "versions", "version");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(Version.class, RedmineDataConverter.Integer, true, allMappers,
                "id",
                "project-id");

        addTagTextContentMappers(Version.class, RedmineDataConverter.Datetime, true, allMappers,
                "created-on",
                "updated-on");
        addTagTextContentMappers(Version.class, RedmineDataConverter.Date, true, allMappers,
                "effective-date");

        addTagTextContentMappers(Version.class, RedmineDataConverter.Text, true, allMappers,
                "name",
                "description",
                "wiki-page-title");
    }
}
