/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import com.sun.java.help.search.Indexer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.plugin.AbstractJaxxMojo;
import org.nuiton.jaxx.plugin.NodeItem;
import org.nuiton.jaxx.plugin.XmlHelper;
import org.nuiton.plugin.VelocityTemplateGenerator;
import org.nuiton.util.FileUtil;
import org.nuiton.util.SortedProperties;

public class GenerateHelpMojo
extends AbstractJaxxMojo {
    private static final String AUTOREMOVE_LINE = "REMOVE THS LINE TO DISABLE AUTO-REGENERATE THE FILE";
    protected File outHelp;
    protected String locales;
    protected String helpsetName;
    protected File helpsetTemplate;
    protected File mapTemplate;
    protected File indexTemplate;
    protected File tocTemplate;
    protected File contentTemplate;
    protected boolean generateSearch;
    private Properties helpIds;
    private Locale defaultLocale;
    private Locale[] localesToTreate;

    public boolean init() throws Exception {
        File idsStore = this.getHelpIdsStore();
        if (!idsStore.exists()) {
            this.getLog().info((CharSequence)("no helpIdStore to react at " + idsStore));
            return false;
        }
        if (this.locales == null || this.locales.trim().isEmpty()) {
            throw new MojoFailureException("You must set the 'locales' property properly (was " + this.locales + ").");
        }
        if (this.outHelp == null) {
            throw new MojoFailureException("You must set the 'target' property.");
        }
        ArrayList<Locale> tmp = new ArrayList<Locale>();
        for (String loc : this.locales.split(",")) {
            Locale l = I18n.newLocale((String)loc);
            tmp.add(l);
        }
        if (tmp.isEmpty()) {
            throw new MojoFailureException("you must set the 'locales' property.");
        }
        this.localesToTreate = tmp.toArray(new Locale[tmp.size()]);
        this.defaultLocale = this.localesToTreate[0];
        this.checkResource(this.helpsetTemplate);
        this.checkResource(this.mapTemplate);
        this.checkResource(this.indexTemplate);
        this.checkResource(this.tocTemplate);
        this.checkResource(this.contentTemplate);
        if (!this.getTargetDirectory().exists()) {
            this.getLog().info((CharSequence)("mkdir " + this.getTargetDirectory()));
            this.getTargetDirectory().mkdirs();
        }
        this.helpIds = new SortedProperties();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(idsStore), this.getEncoding()));
        String id = null;
        while ((id = reader.readLine()) != null) {
            id = id.trim();
            String path = id.replaceAll("\\.", File.separator) + ".html";
            this.helpIds.put(id, path);
        }
        if (this.helpIds.isEmpty()) {
            this.getLog().warn((CharSequence)"No helpIds detected, will skip.");
            return false;
        }
        return true;
    }

    public void doAction() throws Exception {
        int touchedFiles = 0;
        String mapFileName = this.helpsetName + "Map.jhm";
        String indexFileName = this.helpsetName + "Index.xml";
        String tocFileName = this.helpsetName + "TOC.xml";
        for (Locale locale : this.localesToTreate) {
            boolean isDefaultLocale = locale == this.defaultLocale;
            String language = locale.getLanguage();
            String localePath = isDefaultLocale ? "default" : language;
            File localizedTarget = new File(this.outHelp, localePath);
            if (!localizedTarget.exists()) {
                localizedTarget.mkdirs();
            }
            this.getLog().info((CharSequence)("Generate help for language " + language));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("  Localized target : " + localizedTarget));
            }
            Properties env = new Properties();
            env.put("helpSetName", this.helpsetName);
            env.put("locale", language);
            env.put("localePath", localePath);
            env.put("separator", "    ");
            env.put("autoremoveLine", AUTOREMOVE_LINE);
            String localeSuffix = isDefaultLocale ? "" : "_" + language;
            String helpsetFileName = this.helpsetName + localeSuffix + ".hs";
            env.put("helpSetFileName", helpsetFileName);
            env.put("mapFileName", mapFileName);
            env.put("indexFileName", indexFileName);
            env.put("tocFileName", tocFileName);
            env.put("generateSearch", (Object)this.generateSearch);
            File file = new File(this.outHelp, helpsetFileName);
            boolean doCreate = this.generateHelpsetFile(file, env);
            if (doCreate) {
                ++touchedFiles;
            }
            file = new File(localizedTarget, mapFileName);
            this.generateMapFile(file, env);
            ++touchedFiles;
            file = new File(localizedTarget, indexFileName);
            this.generateIndexFile(file, env);
            ++touchedFiles;
            file = new File(localizedTarget, tocFileName);
            this.generateTocFile(file, env);
            ++touchedFiles;
            touchedFiles += this.generateContentFiles(localizedTarget, env, localePath);
            if (!this.generateSearch) continue;
            this.generateSearchIndex(localizedTarget, locale);
        }
        this.getLog().info((CharSequence)(touchedFiles + " file(s) treated."));
    }

    @Override
    public File getTargetDirectory() {
        return this.outHelp;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.outHelp = targetDirectory;
    }

    protected int generateContentFiles(File localizedTarget, Properties env, String localePath) throws Exception {
        int touchedFiles = 0;
        VelocityTemplateGenerator gen = this.prepareGenerator(this.contentTemplate);
        Enumeration<Object> keys = this.helpIds.keys();
        while (keys.hasMoreElements()) {
            String content;
            String key = (String)keys.nextElement();
            String url = (String)this.helpIds.get(key);
            url = this.helpsetName + File.separator + url;
            File f = new File(localizedTarget, url);
            boolean exist = f.exists();
            if (exist && !(content = FileUtil.readAsString((File)f)).contains(AUTOREMOVE_LINE)) {
                if (!this.verbose) continue;
                this.getLog().debug((CharSequence)("skip existing file " + f));
                continue;
            }
            f.getParentFile().mkdirs();
            if (this.verbose) {
                if (exist) {
                    this.getLog().info((CharSequence)("regenerate content file " + f));
                } else {
                    this.getLog().info((CharSequence)("generate   content file " + f));
                }
            }
            env.put("helpId", key);
            env.put("helpIdUrl", localePath + "/" + url);
            gen.generate(env, f);
            ++touchedFiles;
        }
        return touchedFiles;
    }

    protected boolean generateHelpsetFile(File file, Properties env) throws Exception {
        String content;
        if (file.exists() && !(content = FileUtil.readAsString((File)file)).contains(AUTOREMOVE_LINE)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip existing helpset main file " + file));
            }
            return false;
        }
        if (this.verbose) {
            if (file.exists()) {
                this.getLog().info((CharSequence)("regenerate helpset main file " + file));
            } else {
                this.getLog().info((CharSequence)("generate helpset main file " + file));
            }
        }
        this.doGen(this.helpsetTemplate, file, env);
        return true;
    }

    protected Properties generateMapFile(File file, Properties env) throws Exception {
        boolean create;
        Object mergedHelpIds = null;
        if (file.exists()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("loading existing helpset map file " + file));
            }
            mergedHelpIds = XmlHelper.getExistingHelpIds(file, this.verbose, this.getLog());
            create = false;
        } else {
            mergedHelpIds = new SortedProperties();
            create = true;
        }
        for (Object k : this.helpIds.keySet()) {
            ((Properties)mergedHelpIds).put(k, this.helpsetName + "/" + this.helpIds.get(k));
        }
        if (!((Properties)mergedHelpIds).contains("top")) {
            String topUrl = this.helpsetName + ".html";
            this.helpIds.put("top", topUrl);
            ((Properties)mergedHelpIds).put("top", this.helpsetName + "/" + topUrl);
            if (this.verbose) {
                this.getLog().debug((CharSequence)("add top entry with url " + topUrl));
            }
        }
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset map file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset map file " + file));
            }
        }
        env.put("helpIds", mergedHelpIds);
        this.doGen(this.mapTemplate, file, env);
        env.remove("helpIds");
        return mergedHelpIds;
    }

    protected NodeItem generateIndexFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = XmlHelper.getExistingItems("indexitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpsetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.verbose) continue;
            this.getLog().debug((CharSequence)("index " + k + " : " + toc));
        }
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset index file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset index file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.indexTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateSearchIndex(File localizedTarget, Locale locale) throws IllegalArgumentException, IOException, InvocationTargetException, SecurityException, IllegalAccessException, NoSuchMethodException {
        Method m = Indexer.class.getDeclaredMethod("main", String[].class);
        File indexDir = new File(localizedTarget, "JavaHelpSearch");
        FileUtils.deleteDirectory((File)indexDir);
        File tmpDir = new File(this.project.getBasedir(), "target" + File.separator + "jaxx-tmp" + File.separator + "indexer-" + locale + "-" + System.nanoTime());
        this.getLog().info((CharSequence)("copy files to " + tmpDir + " for indexing them"));
        FileUtils.copyDirectory((File)localizedTarget, (File)tmpDir, (String)"**/*", (String)StringUtils.join((Object[])DirectoryScanner.DEFAULTEXCLUDES, (String)","));
        ArrayList<String> params = new ArrayList<String>();
        params.add("-verbose");
        params.add("-db");
        params.add(indexDir.getAbsolutePath());
        params.add("-logfile");
        File logFile = new File(this.project.getBasedir(), "target" + File.separator + "generated-sources" + File.separator + "jaxx" + File.separator + "indexer-" + locale + ".log");
        params.add(logFile.getAbsolutePath());
        params.add(tmpDir.getAbsolutePath());
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            m.invoke(null, new Object[]{params.toArray(new String[params.size()])});
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
        this.getLog().info((CharSequence)"Search Index generated");
    }

    protected NodeItem generateTocFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = XmlHelper.getExistingItems("tocitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpsetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.verbose) continue;
            this.getLog().debug((CharSequence)("toc " + k + " : " + toc));
        }
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset toc file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset toc file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.tocTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    protected void doGen(File template, File f, Properties env) throws Exception {
        VelocityTemplateGenerator gen = this.prepareGenerator(template);
        gen.generate(env, f);
    }

    protected VelocityTemplateGenerator prepareGenerator(File template) throws Exception {
        URL templateURL = this.getTemplate(template);
        if (this.verbose) {
            this.getLog().info((CharSequence)("using template " + templateURL));
        }
        VelocityTemplateGenerator gen = new VelocityTemplateGenerator(this.project, templateURL);
        return gen;
    }
}

