/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jaxx.runtime.swing;

import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.swing.editor.cell.DateCellEditor;
import org.nuiton.jaxx.runtime.swing.editor.cell.KeyStrokeCellEditor;
import org.nuiton.jaxx.runtime.swing.renderer.DateCellRenderer;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/**
 * @author Sylvain Lletellier
 */
public class JAXXWidgetUtil extends SwingUtil {

    public static TableCellRenderer newDateTableCellRenderer(TableCellRenderer renderer) {
        return newDateTableCellRenderer(renderer, null);
    }

    public static TableCellRenderer newDateTableCellRenderer(TableCellRenderer renderer, String datePattern) {
        return new DateCellRenderer(renderer, datePattern);
    }

    public static TableCellEditor newDateTableCellEditor() {
        return new DateCellEditor();
    }

    public static TableCellEditor newKeyStrokeTableCellEditor() {
        return new KeyStrokeCellEditor();
    }

}
