package jaxx.runtime.swing.editor.gis;

/*
 * #%L
 * JAXX :: Widgets
 * $Id: DmdCoordinateConverter.java 2756 2013-11-26 14:10:47Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.6/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/gis/DmdCoordinateConverter.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Matcher;

import static org.nuiton.i18n.I18n._;

/**
 * Created on 11/25/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class DmdCoordinateConverter implements Converter {

    protected boolean useSign;

    protected boolean forLongitude;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    @Override
    public Object convert(Class aClass, Object value) {

        if (!isEnabled(aClass)) {
            throw new ConversionException(
                    _("jaxx.error.no.convertor.coordinateDmd", value));
        }

        Object result = null;

        if (value == null) {

            if (aClass.equals(String.class)) {

                result = String.format(
                        DmdCoordinate.COORDINATE_STRING_PATTERN,
                        useSign ? "-" : "",
                        StringUtils.leftPad("", forLongitude ? 3 : 2, ' '),
                        StringUtils.leftPad("", 2, ' '),
                        StringUtils.leftPad("", 2, ' '));
            }
        } else {

            if (aClass.equals(value.getClass())) {

                // same class, no convertion to do
                result = value;
            } else if (value instanceof String) {

                // String to Value

                Matcher matcher = DmdCoordinate.COORDINATE_PATTERN.matcher((String) value);

                if (matcher.matches()) {

                    String degresStr = matcher.group(1).replaceAll("\\s", "");
                    String minutesStr = matcher.group(2).replaceAll("\\s", "");
                    String decimalesStr = matcher.group(3).replaceAll("\\s", "");

                    Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Math.abs(Integer.valueOf(degresStr));
                    Integer minutes = minutesStr.isEmpty() ? null : Integer.valueOf(minutesStr);
                    Integer decimal = decimalesStr.isEmpty() ? null : Integer.valueOf(decimalesStr);

                    boolean signed = degresStr.contains("-");
                    result = DmdCoordinate.valueOf(signed,
                                                   degre,
                                                   minutes,
                                                   decimal);
                }

            } else if (value instanceof DmdCoordinate) {

                // Value to String

                DmdCoordinate coordinate = (DmdCoordinate) value;

                boolean sign = coordinate.isSign();
                String signStr = sign ? "-" : "";

                Integer degree = coordinate.getDegree();
                String degreeStr = degree == null ? "" : degree.toString();

                Integer minute = coordinate.getMinute();
                String minuteStr = minute == null ? "" : minute.toString();

                Integer decimal = coordinate.getDecimal();
                String decimalStr = decimal == null ? "" : decimal.toString();

                result = String.format(
                        DmdCoordinate.COORDINATE_STRING_PATTERN,
                        signStr,
                        StringUtils.leftPad(degreeStr, forLongitude ? 3 : 2, ' '),
                        StringUtils.leftPad(minuteStr, 2, ' '),
                        StringUtils.leftPad(decimalStr, 2, ' '));
            }
        }
        return result;
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) ||
               DmdCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<?> getType() {
        return DmdCoordinate.class;
    }

}

