package jaxx.runtime.swing.log;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import static org.nuiton.i18n.I18n.t;

public class JAXXLog4jUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LOG_AREA_TEXT = "logArea.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVPW8TQRBdm9iOHUICUUKiBGFCBBFCNgUUKCEfBEKCzIdikCLcsPZt7IvWt8veXnJpED+BnwA9DRIdFaKgpqBB/AWEKGgRs3u2zw7n80nn4mztm3nz3tzO+N1PlLIFurCPXbcgHEuaTVK4v767+6i6T2ryDrFrwuSSCeR9EkmUrKARo3NuS3SxUlLpxVZ6cYM1ObOI1ZW9VEI5Wx5RYjcIkRKd682o2Xax3IGXXO6INmtHVBDrm9+/kq+NV2+TCLkc1I2BlfygLN/JUAklTUOiM1DpABcptuogQ5hWHfSOqrMNim37IW6SF+glypRQmmMBZBLNR7esOXS+yyXKUFa/vv90Gyh6hNqHULYAoO5+yQviXCemJUpJU1Ii0bhSVVBKC55SPyTTwJZBiZDo8iDmLS+yi77JDEIlWhyUuc45sYzu1NGF++WaYJQ+xha5JtFZpdBt5XZBKjzriwXWdUHw8fi7hgm9a8dP+vELT3CVKv7pAIka6y2Q28MS0x1smEzndNXQh7cdKZmlgmf9HCIEExpWJ/leNHuIhdUXNK091g/MGaTq1PuiUuAa6YcOY0r7YWOUHBAPvSeYw4PvlHp3nlsdBG9OoNmeOBi/gj9+/nwkKiglHDiGDlb+n9gdgLxZnT42q4pQo3+nJr59/PFhsz2g01B7MjC0a7/A4HDBONxkU5Ue86bTkSYtPsB8qYKyNqGwnPTymQsQVm7BIA7qndYjo9ILW9huAEUq8/3T56nnX0+g5CbKUYaNTazit1FWNgR0gVHD5atrWtHJw2F4jittEqUpPmLQS3Rq2YD7la+algE9XnGhCXMBTegoqWa//Jkov19rNyIBwmb6hvvNSD1DadOipkX0rmqtocDdNMJt4hjMXzdBCyihvnO8Nb439PNmkNMhSVyp0GXXUV+3tGj1a1VzzETgGKn61w627LJnJI8lbC6AyEow9fmB1Op4I0TcYAZYeQeYOiQWiTreUo/tYIb52EaiMezEZghzsRDbRTSGMBfRGMJcXIrtIhpDmItoDGEuFmO7iMYQ5iIaQ5iLK7FdRGMIcxGNIczF1QhLZtj7pyJGLJ5B3YjGENYNxfAPH+q+WgsMAAA=";
    private static final Log log = LogFactory.getLog(JAXXLog4jUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton allRadio;
    protected JRadioButton debugRadio;
    protected JRadioButton errorRadio;
    protected JRadioButton fatalRadio;
    protected JAXXLog4jHandler handler;
    protected JRadioButton infoRadio;
    protected JAXXButtonGroup levelRadioGroup;
    protected JAXXLog4jUI log4jUI = this;
    protected JEditorPane logArea;
    protected JAXXLog4jAppender model;
    protected String title;
    protected JRadioButton traceRadio;
    protected JRadioButton warnRadio;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Init {@link JAXXLog4jAppender} with level INFO and pattern : {@code %5p [%t] (%F:%L) %M - %m%n}.
         */
        public static void init() {
            JAXXLog4jHandler.init();
        }
    
        /**
         * Init appender with specific level and pattern layout.
         *
         * @param level specify
         * @param patternLayout patternto display
         */
        public static void init(String level, String patternLayout) {
            JAXXLog4jHandler.init(level, patternLayout);
        }
    
        public void showInDialog(Frame ui, boolean undecorated) {
            handler.showInDialog(ui, undecorated);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXLog4jUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JAXXLog4jUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXLog4jUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JAXXLog4jUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXLog4jUI() {
        $initialize();
    }

    public JAXXLog4jUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXLog4jUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public JAXXLog4jUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__allRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.ALL);
    }

    public void doActionPerformed__on__debugRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.DEBUG);
    }

    public void doActionPerformed__on__errorRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.ERROR);
    }

    public void doActionPerformed__on__fatalRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.FATAL);
    }

    public void doActionPerformed__on__infoRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.INFO);
    }

    public void doActionPerformed__on__traceRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.TRACE);
    }

    public void doActionPerformed__on__warnRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setLevel(Level.WARN);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getAllRadio() {
        return allRadio;
    }

    public JRadioButton getDebugRadio() {
        return debugRadio;
    }

    public JRadioButton getErrorRadio() {
        return errorRadio;
    }

    public JRadioButton getFatalRadio() {
        return fatalRadio;
    }

    public JAXXLog4jHandler getHandler() {
        return handler;
    }

    public JRadioButton getInfoRadio() {
        return infoRadio;
    }

    public JAXXButtonGroup getLevelRadioGroup() {
        return levelRadioGroup;
    }

    public JEditorPane getLogArea() {
        return logArea;
    }

    public JAXXLog4jAppender getModel() {
        return model;
    }

    public String getTitle() {
        return title;
    }

    public JRadioButton getTraceRadio() {
        return traceRadio;
    }

    public JRadioButton getWarnRadio() {
        return warnRadio;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAllRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; allRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(allRadio); }
    }

    protected void addChildrenToDebugRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; debugRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(debugRadio); }
    }

    protected void addChildrenToErrorRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; errorRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(errorRadio); }
    }

    protected void addChildrenToFatalRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; fatalRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fatalRadio); }
    }

    protected void addChildrenToInfoRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; infoRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(infoRadio); }
    }

    protected void addChildrenToLog4jUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTraceRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; traceRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(traceRadio); }
    }

    protected void addChildrenToWarnRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = levelRadioGroup; warnRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(warnRadio); }
    }

    protected void createAllRadio() {
        $objectMap.put("allRadio", allRadio = new JRadioButton());
        
        allRadio.setName("allRadio");
        allRadio.setSelected(true);
        allRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__allRadio"));
    }

    protected void createDebugRadio() {
        $objectMap.put("debugRadio", debugRadio = new JRadioButton());
        
        debugRadio.setName("debugRadio");
        debugRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__debugRadio"));
    }

    protected void createErrorRadio() {
        $objectMap.put("errorRadio", errorRadio = new JRadioButton());
        
        errorRadio.setName("errorRadio");
        errorRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__errorRadio"));
    }

    protected void createFatalRadio() {
        $objectMap.put("fatalRadio", fatalRadio = new JRadioButton());
        
        fatalRadio.setName("fatalRadio");
        fatalRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fatalRadio"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new JAXXLog4jHandler(this));
    }

    protected void createInfoRadio() {
        $objectMap.put("infoRadio", infoRadio = new JRadioButton());
        
        infoRadio.setName("infoRadio");
        infoRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__infoRadio"));
    }

    protected void createLevelRadioGroup() {
        $objectMap.put("levelRadioGroup", levelRadioGroup = new JAXXButtonGroup());
    }

    protected void createLogArea() {
        $objectMap.put("logArea", logArea = new JEditorPane());
        
        logArea.setName("logArea");
    }

    protected void createModel() {
        $objectMap.put("model", model = getHandler().getAppender());
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTraceRadio() {
        $objectMap.put("traceRadio", traceRadio = new JRadioButton());
        
        traceRadio.setName("traceRadio");
        traceRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__traceRadio"));
    }

    protected void createWarnRadio() {
        $objectMap.put("warnRadio", warnRadio = new JRadioButton());
        
        warnRadio.setName("warnRadio");
        warnRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__warnRadio"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToLog4jUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(logArea);
        // inline complete setup of $Table0
        $Table0.add(fatalRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(errorRadio, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(warnRadio, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(infoRadio, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(debugRadio, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(traceRadio, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(allRadio, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFatalRadio();
        addChildrenToErrorRadio();
        addChildrenToWarnRadio();
        addChildrenToInfoRadio();
        addChildrenToDebugRadio();
        addChildrenToTraceRadio();
        addChildrenToAllRadio();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        fatalRadio.setText(t(Level.FATAL.toString()));
        { fatalRadio.putClientProperty("$value", Level.FATAL);  Object $buttonGroup = fatalRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        errorRadio.setText(t(Level.ERROR.toString()));
        { errorRadio.putClientProperty("$value", Level.ERROR);  Object $buttonGroup = errorRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        warnRadio.setText(t(Level.WARN.toString()));
        { warnRadio.putClientProperty("$value", Level.WARN);  Object $buttonGroup = warnRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        infoRadio.setText(t(Level.INFO.toString()));
        { infoRadio.putClientProperty("$value", Level.INFO);  Object $buttonGroup = infoRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        debugRadio.setText(t(Level.DEBUG.toString()));
        { debugRadio.putClientProperty("$value", Level.DEBUG);  Object $buttonGroup = debugRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        traceRadio.setText(t(Level.TRACE.toString()));
        { traceRadio.putClientProperty("$value", Level.TRACE);  Object $buttonGroup = traceRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        allRadio.setText(t(Level.ALL.toString()));
        { allRadio.putClientProperty("$value", Level.ALL);  Object $buttonGroup = allRadio.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("log4jUI", log4jUI);
        createTitle();
        createHandler();
        createModel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createLogArea();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFatalRadio();
        createErrorRadio();
        createWarnRadio();
        createInfoRadio();
        createDebugRadio();
        createTraceRadio();
        createAllRadio();
        createLevelRadioGroup();
        // inline creation of log4jUI
        setName("log4jUI");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOG_AREA_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("logs", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(logArea, model.getLogs());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("logs", this);
                }
            }
        });
    }

}