/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: ConfigTableEditor.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/config/ConfigTableEditor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.runtime.swing.editor.config;

import jaxx.runtime.swing.editor.config.model.ConfigTableModel;

import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import java.awt.Component;
import java.util.EventObject;
import java.util.Locale;

import jaxx.runtime.swing.editor.ClassCellEditor;
import jaxx.runtime.swing.editor.EnumEditor;
import jaxx.runtime.swing.editor.LocaleEditor;
import jaxx.runtime.swing.editor.config.model.OptionModel;

/**
 * L'éditeur des valeurs des propriétés d'une configuration
 *
 * @author tchemit <chemit@codelutin.com>
 */
public class ConfigTableEditor implements TableCellEditor {

    protected TableCellEditor delegate;
    protected ConfigTableModel model;

    public ConfigTableEditor(ConfigTableModel model) {
        this.model = model;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        delegate = findDelegate(table, model.getEntry(row));
        return delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return !hasDelegate() ? null : delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !hasDelegate() || delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return hasDelegate() && delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return !hasDelegate() || delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (hasDelegate()) {
            delegate.cancelCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (hasDelegate()) {
            delegate.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (hasDelegate()) {
            delegate.removeCellEditorListener(l);
        }
    }

    protected TableCellEditor findDelegate(JTable table, OptionModel option) {
        Class<?> type = option.getType();
        TableCellEditor editor = table.getDefaultEditor(type);
        TableCellEditor defaultEditor = table.getDefaultEditor(Object.class);
        //TODO always Search from option.getEditor() and store editor as cache
        if (editor == defaultEditor) {
            // find not a specialized editor for the type
            if (type.isEnum()) {
                // add a EnumEditor to table
                editor = new DefaultCellEditor(EnumEditor.newEditor((Class<Enum>) type));
                table.setDefaultEditor(type, editor);
            } else if (type == Class.class) {
                editor = new ClassCellEditor();
                table.setDefaultEditor(type, editor);
            } //else if (type == File.class){
            //  TODO a FileEditor
            //  table.setDefaultEditor(type, delegate);
            //}
            else if (type.equals(Locale.class)) {
                editor = new DefaultCellEditor(LocaleEditor.newEditor());
                table.setDefaultEditor(Locale.class, editor);
            } else {
                editor = table.getDefaultEditor(String.class);
            }
        }
        if (editor == null) {
            throw new IllegalStateException("could not find a editor for type +" + type);
        }
        return editor;
    }

    protected boolean hasDelegate() {
        return delegate != null;
    }
}
