/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jaxx.runtime.swing.editor.config.model.CallBackEntry;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.CallBackMap;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;

public class CallBacksManager {
    protected List<CallBackEntry> callbacks = new ArrayList<CallBackEntry>();
    protected CallBackFinalizer finalizer;

    public CallBackFinalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(CallBackFinalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void registerCallBack(String name, String description, Icon icon, Runnable action) {
        if (name == null) {
            throw new NullPointerException("parameter 'name' can not be null");
        }
        if (action == null) {
            throw new NullPointerException("parameter 'action' can not be null");
        }
        if (description == null) {
            throw new NullPointerException("parameter 'description' can not be null");
        }
        if (icon == null) {
            throw new NullPointerException("parameter 'icon' can not be null");
        }
        if (this.getCallBack(name) != null) {
            throw new IllegalArgumentException("there is already a callback with name '" + name + "'");
        }
        this.callbacks.add(new CallBackEntry(name, description, icon, action));
    }

    public void registerOption(String name, OptionModel option) {
        if (name == null) {
            throw new NullPointerException("parameter 'name' can not be null");
        }
        if (option == null) {
            throw new NullPointerException("parameter 'option' can not be null");
        }
        CallBackEntry callback = this.getCallBack(name);
        if (callback == null) {
            throw new IllegalArgumentException("could not find a callback with name '" + name + "'");
        }
        callback.addOption(option);
    }

    public CallBackMap getCallBacksForSaved(ConfigUIModel model) {
        CallBackMap result = this.getCallBacks(model, true, false);
        return result;
    }

    public CallBackMap getCallBacksForSaved(CategoryModel category) {
        CallBackMap result = this.getCallBacks(category, true, false);
        return result;
    }

    public CallBackMap getCallBacks(ConfigUIModel model, boolean saved, boolean modified) {
        CallBackMap result = new CallBackMap();
        for (CategoryModel categoryModel : model) {
            CallBackMap callBacks = this.getCallBacks(categoryModel, saved, modified);
            for (Map.Entry entry : callBacks.entrySet()) {
                CallBackEntry key = (CallBackEntry)entry.getKey();
                List value = (List)entry.getValue();
                if (result.containsKey(key)) {
                    ((List)result.get(key)).addAll(value);
                    continue;
                }
                result.put(key, value);
            }
            callBacks.clear();
        }
        CallBackFinalizer finalizer = this.getFinalizer();
        if (finalizer != null) {
            result = finalizer.finalize(result);
        }
        return result;
    }

    public CallBackMap getCallBacks(CategoryModel category, boolean saved, boolean modified) {
        CallBackMap result = new CallBackMap();
        for (OptionModel optionModel : category) {
            CallBackEntry callBackEntry;
            if ((!modified || !optionModel.isModified()) && (!saved || !optionModel.isSaved()) || (callBackEntry = this.getCallBack(optionModel)) == null) continue;
            ArrayList<OptionModel> models = (ArrayList<OptionModel>)result.get(callBackEntry);
            if (models == null) {
                models = new ArrayList<OptionModel>();
                result.put(callBackEntry, models);
            }
            models.add(optionModel);
        }
        return result;
    }

    protected CallBackEntry getCallBack(OptionModel option) {
        for (CallBackEntry callback : this.callbacks) {
            if (!callback.getOptions().contains(option)) continue;
            return callback;
        }
        return null;
    }

    protected CallBackEntry getCallBack(String name) {
        for (CallBackEntry callback : this.callbacks) {
            if (!callback.getName().equals(name)) continue;
            return callback;
        }
        return null;
    }
}

