/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MemoryStatusWidget
extends JComponent
implements ActionListener,
JAXXObject {
    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH9jBTvhILKwgAgohiajOUBtBIMgikQMSRiLCDWvfYm843y27c/hCgfgJ/AToaZDoqBAFNQUN4i8gREGLmF07dzY5CFfsnnbezLyZefP6G+S1gnM7LI5dFQUo+tzdvLa9fbu9wzt4g+uOEhJDBcMv54DTgmkvedcI51sN414duVfXw74MAx6MedcaUNK463Pd4xwRzkx6dLSuNhNzLZaR2ouakMqK+vLHd+eF9/yVAxBLYlegUhYP8korOdwAR3gIc5TpCav6LOgSDSWCLvE9at7Wfab1Ldbnj+EZTDWgIJmiYAhL/1+yjWH9Y4kws7yZgC8irEyw1QPK7W7xfqh2m8gw0veE1+UopQ1QQMgbnEKYNezikcNd85Zi5qQKu4prfZ11HnVVGAVU4zHj4LIBUkv8MAtdDxUfoo1lNkWUl5u2po1AoGC+eMoVMV+1zDtUi/C5codlu/uQ/wxzyZgqBFFweqIRJAg3FUQ6sVwL8iqiZ4T51n4N3SHTUD3zf6jHBLTWX5Xy53df39b3JONQ7pOZ0DHF0yipS5IaL0zq40O9RCj86haTtRYUNfdpXew6LGQQa47MRI7y2eG5xt29yXSPQuSnvrz/UHnw6RA4dSj5IfPqzOA3oIg9Gk4v9L1YXl2zjGYGR+g8YbghlNrjQ77sMWSLbRF4pIsrMTViIaMRCZt28ePPcvPN2l4zckTu1F/haUPy96EgAl8E3G7QaDkyN2Zaah55YboEWWuRM3dJjrRy1p5LmdU+nBDpShyZa9VSN38Xkki/AbR9wrLZBAAA";
    private static final Log log = LogFactory.getLog(MemoryStatusWidget.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected Color progressBackground;
    protected Color progressForeground;
    protected Timer timer;
    private MemoryStatusWidget $JComponent0 = this;
    private static final String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc;
    private LineMetrics lm;

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setTimer(new Timer(2000, this));
        this.timer.start();
    }

    @Override
    public void removeNotify() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.removeNotify();
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)(runtime.freeMemory() / 1024L);
        int totalMemory = (int)(runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float)usedMemory / (float)totalMemory;
        g.setColor(this.progressBackground);
        g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
        String str = I18n._((String)"memorywidget.memory", (Object[])new Object[]{usedMemory / 1024, totalMemory / 1024});
        Rectangle2D bounds = g.getFont().getStringBounds(str, this.frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top, (int)((float)width * fraction), height);
        g2.setColor(this.progressForeground);
        g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), height);
        g2.setColor(this.getForeground());
        g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
        g2.dispose();
    }

    void $afterCompleteSetup() {
        this.setFont(new JLabel().getFont());
        Rectangle2D bounds = this.getFont().getStringBounds(memoryTestStr, this.frc);
        Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public MemoryStatusWidget() {
        this.$initialize();
    }

    public MemoryStatusWidget(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public Color getProgressBackground() {
        return this.progressBackground;
    }

    public Color getProgressForeground() {
        return this.progressForeground;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setProgressBackground(Color newValue) {
        Color oldValue = this.progressBackground;
        this.progressBackground = newValue;
        this.firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, newValue);
    }

    public void setProgressForeground(Color newValue) {
        Color oldValue = this.progressForeground;
        this.progressForeground = newValue;
        this.firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, newValue);
    }

    public void setTimer(Timer newValue) {
        Timer oldValue = this.timer;
        this.timer = newValue;
        this.firePropertyChange(PROPERTY_TIMER, oldValue, newValue);
    }

    protected void createProgressBackground() {
        this.progressBackground = Color.decode("#666699a");
        this.$objectMap.put(PROPERTY_PROGRESS_BACKGROUND, this.progressBackground);
    }

    protected void createProgressForeground() {
        this.progressForeground = Color.decode("#cccccc");
        this.$objectMap.put(PROPERTY_PROGRESS_FOREGROUND, this.progressForeground);
    }

    protected void createTimer() {
        this.timer = null;
        this.$objectMap.put(PROPERTY_TIMER, null);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$JComponent0", this);
        this.createTimer();
        this.createProgressBackground();
        this.createProgressForeground();
        this.frc = new FontRenderContext(null, false, false);
        this.lm = new JLabel().getFont().getLineMetrics(memoryTestStr, this.frc);
        this.setName("$JComponent0");
        this.$completeSetup();
    }
}

