/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class TimeEditor extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_TIME_MODEL = "timeModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_ENABLED = "hour.enabled";
    public static final String BINDING_HOUR_VALUE = "hour.value";
    public static final String BINDING_MINUTE_ENABLED = "minute.enabled";
    public static final String BINDING_MINUTE_VALUE = "minute.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_VALUE = "slider.value";
    public static final String BINDING_TITLE_TEXT = "title.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVTU8TQRieLm2hoIiiRqMmiBhBsS2oRINRVCRA6kcoB2MvTrtDOzidHWdmZZFo/An+BL17MfHmyXjw7MGL8S8Y48Gr8Z3ZLUthBS426XZn3o953mfe5+3bHyijJDq5jIMgL32uaZPk5288eHCvukxqepqomqRCexKFn5SDnArqcdf3lUanKiUTXojCC7e8pvA44RuiJ0uoW+lVRlSDEK3RifaImlKF8rp5MhC+bGVdB5WU9fWvn84r9+UbB6FAALpeKGVgp6i4knQJOdTV6ACc9BQXGOZ1gCEprwPevWbvFsNK3cVN8gS9QJ0llBVYQjKNBndfss1h4wOhUdfQ/H3MCStqNNSGVK3AuXniUojNL8LObfsqhI3NQqSQniBSr2rUZ7DlDd58iDf2yjBcJcwseuPNdJVg3hYWXm/skTMY7nguYRrtj93muCZ1sgFE2sWaaNRrXXxNWX4aNmJ7ZwNzlwFKdG431c2G3hvihxZxlRFg50hCvLUZz1xcr6aaAaIDBlEQ+c2XWiSciOkbCneLZj3Ybks3PB8gH2zLURaUcyLbPbOW3tmEHNkm5b626M5ssihGXUNJf3t+uxtVI9GxtnpBEflYEXHLpiooI33YBoIqW0W0AKZQPkc2yccktNY/h/u/fvj+fqalmSycfSjRdYPkoZej7qPm6H2hYMz9F+5gMVlBOUUYNJSdB8cTgJUjM4CD8/bH7TOLVQNSZDq/ffx0+NGXDuTMoG7mYXcGG/856MyGBBY85gbi+pRFtGelC5598HWA1IYn6TOPa8xuMFrnTavPbA1+DOdpTQJY71mrE23vf3jkeQD8HE/gZx1kNff5d3/53VSLoxRgPvpP95inzEOUpZxRTuxkiYZG4iTpEYr4rhcPh6RxgVr9LSKFXLTPy1t46ADlEG7UAeNs7xpVt8MFFAspmqGuB9c4WRmI2vqu36wSaRU/XBwtjo5fGB2zzk8x86Hj+g1hi62hMDxSmCgCb+b0a5YQ8zaFIunsBG/312TIjabEbNJxkf7+Px+XrmzPx+l/8BGNgZ0AdsE0buJlTy7S2uOywDUYCRo5E8XtgHcLTLk2EcowJg2uVjHnbDHTZAn7TN/0fO4SdwFGOGmVNAZFTRTPjl80mXpsJquHOFUfQN8M6AIAyi3BtZ1X9Bn4OGNjMSd9mzhJJiScfjsRkrJ3u+r50AW9V+FfBg9UKXcBxbUtWVPm2Q0Z/wIeQTKKvggAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.TimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Object bean;
    protected java.util.Date date;
    protected jaxx.runtime.swing.editor.TimeEditorHandler handler;
    protected javax.swing.JSpinner hour;
    protected java.lang.String label;
    protected javax.swing.JLabel labelH;
    protected javax.swing.JSpinner minute;
    protected java.lang.String property;
    protected javax.swing.JSlider slider;
    protected java.lang.Integer timeModel;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditor $JPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditor() {
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hour(javax.swing.event.ChangeEvent event) {
        setTimeModel((Integer)hour.getValue()* 60 + timeModel % 60);
    }

    public void doStateChanged__on__minute(javax.swing.event.ChangeEvent event) {
        setTimeModel((timeModel / 60) * 60 + (Integer) minute.getValue());
    }

    public void doStateChanged__on__slider(javax.swing.event.ChangeEvent event) {
        if (!slider.getValueIsAdjusting()) setTimeModel(slider.getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Object getBean() {
        return bean;
    }

    public java.util.Date getDate() {
        return date;
    }

    public jaxx.runtime.swing.editor.TimeEditorHandler getHandler() {
        return handler;
    }

    public javax.swing.JSpinner getHour() {
        return hour;
    }

    public java.lang.String getLabel() {
        return label;
    }

    public javax.swing.JLabel getLabelH() {
        return labelH;
    }

    public javax.swing.JSpinner getMinute() {
        return minute;
    }

    public java.lang.String getProperty() {
        return property;
    }

    public javax.swing.JSlider getSlider() {
        return slider;
    }

    public java.lang.Integer getTimeModel() {
        return timeModel;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(java.lang.Object newValue) {
        java.lang.Object oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setDate(java.util.Date newValue) {
        java.util.Date oldValue = this.date;
        this.date = newValue;
        firePropertyChange(PROPERTY_DATE, oldValue, newValue);
    }

    public void setLabel(java.lang.String newValue) {
        java.lang.String oldValue = this.label;
        this.label = newValue;
        firePropertyChange(PROPERTY_LABEL, oldValue, newValue);
    }

    public void setProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.property;
        this.property = newValue;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, newValue);
    }

    public void setTimeModel(java.lang.Integer newValue) {
        java.lang.Integer oldValue = this.timeModel;
        this.timeModel = newValue;
        firePropertyChange(PROPERTY_TIME_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDate() {
        $objectMap.put("date", date = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.editor.TimeEditorHandler(this));
    }

    protected void createHour() {
        $objectMap.put("hour", hour = new javax.swing.JSpinner());
        hour.setName("hour");
        hour.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hour"));
    }

    protected void createLabel() {
        $objectMap.put("label", label = "");
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new javax.swing.JLabel());
        labelH.setName("labelH");
        labelH.setHorizontalAlignment(0);
        labelH.setText(_("timeeditor.H"));
    }

    protected void createMinute() {
        $objectMap.put("minute", minute = new javax.swing.JSpinner());
        minute.setName("minute");
        minute.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minute"));
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new javax.swing.JSlider());
        slider.setName("slider");
        slider.setValue(0);
        slider.setMajorTickSpacing(60);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setMinorTickSpacing(30);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createTimeModel() {
        $objectMap.put("timeModel", timeModel = 0);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
        title.setHorizontalAlignment(0);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($Table0, BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(hour, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(labelH, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(minute, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        hour.setModel(new SpinnerNumberModel(0,0,23,1));
        minute.setModel(new SpinnerNumberModel(0,0,59,1));
        slider.setModel(new DefaultBoundedRangeModel(0,1,0,60*24));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 7 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createProperty();
        createLabel();
        createBean();
        createTimeModel();
        createDate();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        createHour();
        createLabelH();
        createMinute();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"label") {
        
            @Override
            public void processDataBinding() {
                title.setText(_(getLabel()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hour.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_VALUE, true ,"timeModel") {
        
            @Override
            public void processDataBinding() {
                hour.setValue(getTimeModel()/60);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minute.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_VALUE, true ,"timeModel") {
        
            @Override
            public void processDataBinding() {
                minute.setValue(getTimeModel()%60);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_VALUE, true ,"timeModel") {
        
            @Override
            public void processDataBinding() {
                slider.setValue(getTimeModel());
            }
        });
    }

}