package jaxx.runtime.swing.editor;

import jaxx.runtime.swing.editor.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import java.util.Locale;
import jaxx.runtime.swing.renderer.LocaleListCellRenderer;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nEditor extends javax.swing.JPanel implements PropertyChangeListener,  ActionListener, jaxx.runtime.JAXXObject {
    public static final String PROPERTY_LOCALES = "locales";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_BORDER = "popupBorder";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SELECTED_LOCALE = "selectedLocale";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_ICON = "showIcon";
    public static final String PROPERTY_SHOW_POPUP_ICON = "showPopupIcon";
    public static final String PROPERTY_SHOW_POPUP_TEXT = "showPopupText";
    public static final String PROPERTY_SHOW_TEXT = "showText";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.I18nEditor.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRQeKm0plAoSG4iYIBKiidmqJxMIIiBaUpRQYgg96LQ70iHDzrgzK4sH45/gn6B3LybePBkPnj14Mf4Lxnjwanwzu9ulsNbG9tBu5733ve/9mG/ffEdp6aILe9j3LddzFN0n1tqt7e379T3SUCtENlwqFHdR8OlLoVQNDdmtc6nQxVpFh5fC8NIy3xfcIc6R6LkKGpTqkBHZJEQpdL49oiFlqdoyz/nCcyPUFqkk1Fc/f6Re2i9epxDyBbAbhVKm/hUVV9JfQSlqK3QGMj3FJYadXaDhUmcX+A7rs2WGpbyH98kT9BxlKygjsAtgCk13X7LBMPG+UCjb4I4yEDNtROUBpLWITSHUKl+74dw2j0KY0IxCY5IwmAixtzhnW1RsER9ARjRLSzO3AuZxQNHhqnoyRlsLsdeQ4MITS9y1iavQhIbzQzJ1c2gFtjhiQDb5QZB9NM6+BBkIdo65laFa/b8Ynw/r8w2dNGKTaEyIzBuqD6ikdUaO2bKMNzDsj0IFw8lTlFkVKlXsUogaWDGuUe8CT3N0hDxMGYrWLbmeMKbIGsbpPMuEsc3wWIPkWlhpQxvmcbS3a6bIdeJ4cdJB41jBdcJgJ9u8zaF2u9TyztQ9pWCX2me2tsV3dxlZMrZ2HlkK7HzdoumEkvSdD6LuuBxIxXs3UzUbXXaoopjRZ8S9qtCsgWjA2lMGfQiW3jrhCTAuOteWDu66Fd/1+DL21VDa9cwIx2sn5WETTIEwjB8TBg1orL+LY1/ef3u3GqlBHnKfTXQ9ImZwS4XLBUya6tSnAynQS1Fax2KuhnLB2hilm0wgVg3NQA7yjcY7dRfLJkCks18/fCw++nwKpVbRIOPYXsXav4xyqulCFzizfXFz0TDKHwzA94jmBhNm+JDDSFBh3sYKT9VhgDCqBR+aMJnQhBaTeu7Tr7Hq28WoEX1AbOKv7nEz0jsoQx1GHWKEMdS8RCEcEpJ4No+1LUnt+vTvYLRL8+Z7ManSNq1Y9j39s2KI66dVgzPbLU4kKz3gZALp64ByuQuULHEwKJV+wcwHbZ3CCkQaLi5ZSIa90gVsvwoL3Pl/jPxj3vDkBqbwLrI7YJW6wMoZLBxqcg9A/bTzBnSDMRCJfE84+vhhj0yGVPs7twPUHyypYkKFCQAA";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.JToggleButton button;
    protected I18nEditor content = this;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected jaxx.runtime.swing.JAXXButtonGroup indexes;
    protected java.util.List< Locale > locales;
    protected java.lang.String notSelectedToolTipText;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.border.Border popupBorder;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.Boolean popupVisible;
    protected jaxx.runtime.swing.renderer.LocaleListCellRenderer renderer;
    protected java.util.Locale selectedLocale;
    protected java.lang.String selectedToolTipText;
    protected java.lang.Boolean showIcon;
    protected java.lang.Boolean showPopupIcon;
    protected java.lang.Boolean showPopupText;
    protected java.lang.Boolean showText;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource2 = new DataBindingListener(this, "renderer.showIcon");
    private PropertyChangeListener $DataSource3 = new DataBindingListener(this, "renderer.showText");
    private PropertyChangeListener $DataSource4 = new DataBindingListener(this, "popup.border");
    private PropertyChangeListener $DataSource5 = new DataBindingListener(this, "button.icon");
    private PropertyChangeListener $DataSource6 = new DataBindingListener(this, "button.selected");
    private PropertyChangeListener $DataSource7 = new DataBindingListener(this, "button.text");
    private PropertyChangeListener $DataSource8 = new DataBindingListener(this, "button.toolTipText");

    /* begin raw body code */
    public static final String DEFAULT_SELECTED_TOOLTIP = n_("i18neditor.selected");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = n_("i18neditor.unselected");
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String SHOW_POPUP_ICON_PROPERTY = "showPopupIcon";
    public static final String SHOW_POPUP_TEXT_PROPERTY = "showPopupText";
    public static final String POPUP_BORDER_PROPERTY = "popupBorder";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        }
        log.info(name + " <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        if (LOCALES_PROPERTY.equals(name)) {
            java.util.Collection<?> newLocales = (java.util.Collection<?>) evt.getNewValue();
            // mise a jour de la popup
            boolean oldShowText = renderer.isShowText();
            try {
                renderer.setShowText(true);
                popup.removeAll();
                for (Object o : newLocales) {
                    Locale l = (Locale) o;
                    boolean selected = l.equals(selectedLocale);
                    String text = isShowPopupText() ? renderer.getText(l) : null;
                    Icon icon = isShowPopupIcon() ? renderer.getIcon(l) : null;
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(text, icon, selected);
                    popup.add(b);
                    b.addActionListener(this);
                    b.putClientProperty("locale", l);
                    b.setToolTipText(getTip(l));
                    b.putClientProperty(JAXXButtonGroup.BUTTON8GROUP_CLIENT_PROPERTY, getIndexes());
                    b.putClientProperty(JAXXButtonGroup.VALUE_CLIENT_PROPERTY, l);
                }
            } finally {
                renderer.setShowText(oldShowText);
                popup.invalidate();
            }
            return;
        }
        if (SHOW_ICON_PROPERTY.equals(name)) {
            renderer.setShowIcon((Boolean) evt.getNewValue());
            processDataBinding("button.icon");
            return;
        }
        if (SHOW_TEXT_PROPERTY.equals(name)) {
            renderer.setShowText((Boolean) evt.getNewValue());
            processDataBinding("button.text");
            return;
        }
        if (SHOW_POPUP_ICON_PROPERTY.equals(name)) {
            rebuildPopup();
            return;
        }
        if (SHOW_POPUP_TEXT_PROPERTY.equals(name)) {
            rebuildPopup();
            return;
        }
        if (POPUP_BORDER_PROPERTY.equals(name)) {
            popup.setBorder((Border)evt.getNewValue());
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean) evt.getNewValue();
            if (newValue == null || !newValue) {
                if (getPopup() != null && getPopup().isVisible()) {
                    getPopup().setVisible(false);
                }
                return;
            }
            if (!getPopup().isVisible()) {
                SwingUtilities.invokeLater(showPopupRunnable);
            }
            return;
        }
        if (SELECTED_LOCALE_PROPERTY.equals(name)) {
            Locale newLocale = (Locale) evt.getNewValue();
            // mise a jour de la popup
            try {
                for (Component c : popup.getComponents()) {
                    if (c instanceof JRadioButtonMenuItem) {
                        JRadioButtonMenuItem b = (JRadioButtonMenuItem) c;
                        Locale l = (Locale) b.getClientProperty("locale");
                        b.setSelected(newLocale.equals(l));
                    }
                }
            } finally {
                popup.invalidate();
            }
            return;
        }
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        Locale value = (Locale) ((JComponent)event.getSource()).getClientProperty("locale");
        if (log.isDebugEnabled()) {
            log.debug("new locale : " + value);
        }
        setSelectedLocale(value);
    }
    
    public void loadI18nBundles() {
        Locale[] locales = org.nuiton.i18n.I18n.getLoader().getLocales();
        setLocales(java.util.Arrays.asList(org.nuiton.i18n.I18n.getLoader().getLocales()));
    }
    
    protected void rebuildPopup() {
        log.debug("start rebuild");
        try {
            for (Component c : popup.getComponents()) {
                if (c instanceof JRadioButtonMenuItem) {
                    JRadioButtonMenuItem b = (JRadioButtonMenuItem) c;
                    Locale l = (Locale) b.getClientProperty("locale");
                    String text = isShowPopupText() ? renderer.getSafeText(l) : null;
                    Icon icon = isShowPopupIcon() ? renderer.getSafeIcon(l) : null;
                    b.setIcon(icon);
                    b.setText(text);
                    log.debug("text=" + text);
                    log.debug("icon=" + icon);
                }
            }        
        } finally {
            popup.invalidate();
        }
    }
    
    protected String getTip(Locale l) {
        boolean selected = l.equals(selectedLocale);    
        String tip = selected ? getSelectedTip(l):getNotSelectedTip(l);
        return tip;
    }
    
    protected String getSelectedTip(Locale l) {
        String selectedTip = getSelectedToolTipText();
        if (selectedTip == null) {
            // use default selected tip text
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        String tip = renderer.getToolTipText(l);
        tip = _(selectedTip, tip);
        return tip;
    }
    
    protected String getNotSelectedTip(Locale l) {
        String selectedTip = getNotSelectedToolTipText();
        if (selectedTip == null) {
            // use default not selected tip text
            selectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        String tip = renderer.getToolTipText(l);
        tip = _(selectedTip, tip);
        return tip;
    }protected Runnable showPopupRunnable;
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public I18nEditor() {
        $initialize();
    }

    public I18nEditor(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {    
            addPropertyChangeListener("showIcon", $DataSource2);
        } else if ("renderer.showText".equals($binding)) {    
            addPropertyChangeListener("showText", $DataSource3);
        } else if ("popup.border".equals($binding)) {    
            addPropertyChangeListener("popupBorder", $DataSource4);
        } else if ("button.icon".equals($binding)) {    
            addPropertyChangeListener("selectedLocale", $DataSource5);
        } else if ("button.selected".equals($binding)) {    
            if (popup != null) {
                $bindingSources.put("popup", popup);
                popup.addComponentListener( Util.getEventListener(ComponentListener.class, content, "$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {    
            addPropertyChangeListener("selectedLocale", $DataSource7);
        } else if ("button.toolTipText".equals($binding)) {    
            addPropertyChangeListener("selectedLocale", $DataSource8);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("renderer.showIcon".equals($dest)) {
                renderer.setShowIcon(isShowIcon());
            } else if ("renderer.showText".equals($dest)) {
                renderer.setShowText(isShowText());
            } else if ("popup.border".equals($dest)) {
                popup.setBorder(getPopupBorder());
            } else if ("button.icon".equals($dest)) {
                button.setIcon(renderer.getIcon(getSelectedLocale()));
            } else if ("button.selected".equals($dest)) {
                if (popup != null) {
                    button.setSelected(popup.isVisible());
                }
            } else if ("button.text".equals($dest)) {
                button.setText(_(SwingUtil.getStringValue(renderer.getText(getSelectedLocale()))));
            } else if ("button.toolTipText".equals($dest)) {
                button.setToolTipText(_(getTip(getSelectedLocale())));
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {    
            removePropertyChangeListener("showIcon", $DataSource2);
        } else if ("renderer.showText".equals($binding)) {    
            removePropertyChangeListener("showText", $DataSource3);
        } else if ("popup.border".equals($binding)) {    
            removePropertyChangeListener("popupBorder", $DataSource4);
        } else if ("button.icon".equals($binding)) {    
            removePropertyChangeListener("selectedLocale", $DataSource5);
        } else if ("button.selected".equals($binding)) {    
            if (popup != null) {
                javax.swing.JPopupMenu $target = ((javax.swing.JPopupMenu) $bindingSources.remove("popup"));
                if ($target != null) {
                    $target.removeComponentListener( Util.getEventListener(ComponentListener.class, content, "$pr$u0"));
                }
            }
        } else if ("button.text".equals($binding)) {    
            removePropertyChangeListener("selectedLocale", $DataSource7);
        } else if ("button.toolTipText".equals($binding)) {    
            removePropertyChangeListener("selectedLocale", $DataSource8);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doFocusGained__on__content(java.awt.event.FocusEvent event) {
        button.requestFocus();
    }

    public void doFocusLost__on__content(java.awt.event.FocusEvent event) {
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(java.awt.event.ItemEvent event) {
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; };
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doStateChanged__on__indexes(javax.swing.event.ChangeEvent event) {
        log.info(indexes.getSelectedValue());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public java.util.List< Locale > getLocales() {
        return locales;
    }

    public java.lang.String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.border.Border getPopupBorder() {
        return popupBorder;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public jaxx.runtime.swing.renderer.LocaleListCellRenderer getRenderer() {
        return renderer;
    }

    public java.util.Locale getSelectedLocale() {
        return selectedLocale;
    }

    public java.lang.String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public java.lang.Boolean getShowIcon() {
        return showIcon;
    }

    public java.lang.Boolean getShowPopupIcon() {
        return showPopupIcon;
    }

    public java.lang.Boolean getShowPopupText() {
        return showPopupText;
    }

    public java.lang.Boolean getShowText() {
        return showText;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public java.lang.Boolean isShowIcon() {
        return showIcon !=null && showIcon;
    }

    public java.lang.Boolean isShowPopupIcon() {
        return showPopupIcon !=null && showPopupIcon;
    }

    public java.lang.Boolean isShowPopupText() {
        return showPopupText !=null && showPopupText;
    }

    public java.lang.Boolean isShowText() {
        return showText !=null && showText;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setLocales(java.util.List< Locale > newValue) {
        java.util.List< Locale > oldValue = this.locales;
        this.locales = newValue;
        firePropertyChange(PROPERTY_LOCALES, oldValue, newValue);
    }

    public void setNotSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setPopupBorder(javax.swing.border.Border newValue) {
        javax.swing.border.Border oldValue = this.popupBorder;
        this.popupBorder = newValue;
        firePropertyChange(PROPERTY_POPUP_BORDER, oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, newValue);
    }

    public void setRenderer(jaxx.runtime.swing.renderer.LocaleListCellRenderer newValue) {
        jaxx.runtime.swing.renderer.LocaleListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        firePropertyChange(PROPERTY_RENDERER, oldValue, newValue);
    }

    public void setSelectedLocale(java.util.Locale newValue) {
        java.util.Locale oldValue = this.selectedLocale;
        this.selectedLocale = newValue;
        firePropertyChange(PROPERTY_SELECTED_LOCALE, oldValue, newValue);
    }

    public void setSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setShowIcon(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showIcon;
        this.showIcon = newValue;
        firePropertyChange(PROPERTY_SHOW_ICON, oldValue, newValue);
    }

    public void setShowPopupIcon(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showPopupIcon;
        this.showPopupIcon = newValue;
        firePropertyChange(PROPERTY_SHOW_POPUP_ICON, oldValue, newValue);
    }

    public void setShowPopupText(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showPopupText;
        this.showPopupText = newValue;
        firePropertyChange(PROPERTY_SHOW_POPUP_TEXT, oldValue, newValue);
    }

    public void setShowText(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showText;
        this.showText = newValue;
        firePropertyChange(PROPERTY_SHOW_TEXT, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ComponentEvent event) {
        $DataSource6.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToContent();
        addChildrenToPopup();
        // init data bindings
        applyDataBinding("renderer.showIcon");
        applyDataBinding("renderer.showText");
        applyDataBinding("popup.border");
        applyDataBinding("button.icon");
        applyDataBinding("button.selected");
        applyDataBinding("button.text");
        applyDataBinding("button.toolTipText");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("content", this);
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupBorder();
        createShowText();
        createShowIcon();
        createShowPopupText();
        createShowPopupIcon();
        createPopupVisible();
        createLocales();
        createSelectedLocale();
        createRenderer();
        createPopup();
        createPopupLabel();
        createButton();
        createIndexes();
        create$ScriptInitializer0();
        // inline creation of content
        setName("content");
        setLayout(new BorderLayout());
        content.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__content"));
        content.addFocusListener(Util.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__content"));
        
        addPropertyChangeListener(this);$completeSetup();
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        add(renderer);
        add(button, BorderLayout.CENTER);
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
    }

    protected void create$ScriptInitializer0() {
        showPopupRunnable = new Runnable() {
            @Override
            public void run() {
                getPopup().pack();
                JToggleButton invoker = getButton();
                Dimension dim = getPopup().getPreferredSize();
                Dimension invokerDim = invoker.getSize();
                getPopup().show(invoker, (int) (invokerDim.getWidth() - dim.getWidth()), invoker.getHeight());
        //        getPopup().setVisible(true);
            }
        };
    }

    protected void createButton() {
        $objectMap.put("button", button = new javax.swing.JToggleButton());
        button.setName("button");
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.addItemListener(Util.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__button"));
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new jaxx.runtime.swing.JAXXButtonGroup());
        indexes.addChangeListener(Util.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createLocales() {
        $objectMap.put("locales", locales = null);
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupBorder() {
        $objectMap.put("popupBorder", popupBorder = new TitledBorder(_("i18neditor.popup.title")));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(_("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = Boolean.FALSE);
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = new LocaleListCellRenderer(showIcon , showText));
        renderer.setName("renderer");
    }

    protected void createSelectedLocale() {
        $objectMap.put("selectedLocale", selectedLocale = Locale.getDefault());
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowIcon() {
        $objectMap.put("showIcon", showIcon = Boolean.TRUE);
    }

    protected void createShowPopupIcon() {
        $objectMap.put("showPopupIcon", showPopupIcon = Boolean.TRUE);
    }

    protected void createShowPopupText() {
        $objectMap.put("showPopupText", showPopupText = Boolean.TRUE);
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = Boolean.TRUE);
    }

}