package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusMessagePanel extends jaxx.runtime.swing.Table implements ActionListener, jaxx.runtime.JAXXObject {
    public static final String PROPERTY_SHOW_CLOCK = "showClock";
    public static final String PROPERTY_SHOW_I18N = "showI18n";
    public static final String PROPERTY_SHOW_MEMORY_STATUS = "showMemoryStatus";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.StatusMessagePanel.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdX7Ad2+QDAlEiAgpgOnQmVEhGEGJkJZENCCMlwg17vpV9Yb277O7hS4P4CfwE6GmQ6KgQBTUFDeIvIERBi9i9c+7OySHiwpZm3nvzdvzm7Q/ISwEX91AQ2MKnyhtie/vO7u59Zw/31F0se8LjigmIPjkLrC5U3LguFVzutgy9NqbXGmzIGcU0xa63oCzVPsFygLFScH6S0ZOy1onb9YD74kA1NpWl+vrXT+uV+/KNBRBw7a6kn7L6P1bykhMtsDxXwWk96TmqEUT72obwaF/7nTG1BkFS3kND/AxeQLEFBY6EFlNw6fhPDjVCfsAVFKuPkEPwNQVXJozKkR5rdxRSvmxjKVEfP0AUE85DbkHBvBywURsPmdiPYApOGY+28W1vMEYwogm8ZOANwnpPTWE2aUybxtbaDXqoXhwg6hIsFFw9lrPNCJ4IVGSIaSEHE71U4y0Ys7fDosGVYviUwwIFc2nYBgsmMWeq6QfveG4fq7Xs1R0FGo3lWGqmGi4jal1XcCFDI4UYkwWcm8DppNpJUpMo5bqQF74uK1jqHg33Q92KYr10KNZGMOz+WVz4+uH7++ZBlnN69tlMaOoUdca4YFz/aZ4ZPRcF2VceqbURr3d1CjDRdxze6UqGsc64rc3peVGeDN3eRHKgJfLFbx8/LT75MgVWE8qEIbeJDH4LSmog9BYYcQN+ez10dHI0rb/njTcFBYcJ16Rp9qaLFFp1POrqHd8K9BJWMpYQO3FKn38vdN6tpxex/E94soz8Yyh4lHgUh2c9vtjMM65wiX2XJZeZdas581vmnP8FfDLMHiQFAAA=";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.Box box;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected jaxx.runtime.swing.StatusMessagePanelHandler handler;
    protected java.lang.Boolean showClock;
    protected java.lang.Boolean showI18n;
    protected java.lang.Boolean showMemoryStatus;
    protected javax.swing.JLabel statusLabel;
    private jaxx.runtime.swing.ClockWidget $ClockWidget2;
    private jaxx.runtime.swing.MemoryStatusWidget $MemoryStatusWidget1;
    private StatusMessagePanel $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /* begin raw body code */
    // To ensure status bar constant height, no matter what font are in use...
    protected final static String EMPTY_STATUS = " ";
    
    
    public void clearStatus() {
        handler.stopStatusFader(this);
        getStatusLabel().setText(EMPTY_STATUS);
    }
    
    public void setStatus(String status) {
        handler.stopStatusFader(this);
        getStatusLabel().setText(status);
        handler.startStatusFader(this);
    }
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        handler.fadeStatus(this);
    }
    
    public <U extends Component> U getWidget(Class<U> clazz) {
        for (Component component : box.getComponents()) {
            if (clazz == component.getClass()) {
                return (U) component;
            }
        }
        return null;
    }
    
    public void addWidget(Component w) {
        box.add(w);
    }
    
    public void addWidget(Component w, int index) {
        box.add(w, index);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public StatusMessagePanel() {
        $initialize();
    }

    public StatusMessagePanel(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    @Override
    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.Box getBox() {
        return box;
    }

    public jaxx.runtime.swing.StatusMessagePanelHandler getHandler() {
        return handler;
    }

    public java.lang.Boolean getShowClock() {
        return showClock;
    }

    public java.lang.Boolean getShowI18n() {
        return showI18n;
    }

    public java.lang.Boolean getShowMemoryStatus() {
        return showMemoryStatus;
    }

    public javax.swing.JLabel getStatusLabel() {
        return statusLabel;
    }

    public java.lang.Boolean isShowClock() {
        return showClock !=null && showClock;
    }

    public java.lang.Boolean isShowI18n() {
        return showI18n !=null && showI18n;
    }

    public java.lang.Boolean isShowMemoryStatus() {
        return showMemoryStatus !=null && showMemoryStatus;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setShowClock(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showClock;
        this.showClock = newValue;
        firePropertyChange(PROPERTY_SHOW_CLOCK, oldValue, newValue);
    }

    public void setShowI18n(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showI18n;
        this.showI18n = newValue;
        firePropertyChange(PROPERTY_SHOW_I18N, oldValue, newValue);
    }

    public void setShowMemoryStatus(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showMemoryStatus;
        this.showMemoryStatus = newValue;
        firePropertyChange(PROPERTY_SHOW_MEMORY_STATUS, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.ClockWidget get$ClockWidget2() {
        return $ClockWidget2;
    }

    protected jaxx.runtime.swing.MemoryStatusWidget get$MemoryStatusWidget1() {
        return $MemoryStatusWidget1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add(statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        add(box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToBox();
        // init data bindings
        setBorder(BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createShowMemoryStatus();
        createShowClock();
        createShowI18n();
        createHandler();
        createStatusLabel();
        createBox();
        // inline creation of $MemoryStatusWidget1
        $objectMap.put("$MemoryStatusWidget1", $MemoryStatusWidget1 = new jaxx.runtime.swing.MemoryStatusWidget());
        $MemoryStatusWidget1.removeDataBinding("$JComponent0.name");
        $MemoryStatusWidget1.setName("$MemoryStatusWidget1");
        // inline creation of $ClockWidget2
        $objectMap.put("$ClockWidget2", $ClockWidget2 = new jaxx.runtime.swing.ClockWidget());
        $ClockWidget2.removeDataBinding("$JLabel0.name");
        $ClockWidget2.setName("$ClockWidget2");
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    protected void addChildrenToBox() {
        if (!allComponentsCreated) {
            return;
        }
        box.add($MemoryStatusWidget1);
        box.add($ClockWidget2);
    }

    protected void createBox() {
        $objectMap.put("box", box = new javax.swing.Box(0));
        box.setName("box");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.StatusMessagePanelHandler());
    }

    protected void createShowClock() {
        $objectMap.put("showClock", showClock = Boolean.TRUE);
    }

    protected void createShowI18n() {
        $objectMap.put("showI18n", showI18n = Boolean.FALSE);
    }

    protected void createShowMemoryStatus() {
        $objectMap.put("showMemoryStatus", showMemoryStatus = Boolean.TRUE);
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new javax.swing.JLabel());
        statusLabel.setName("statusLabel");
    }

}