/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: TranslucentValidationUI.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.8/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/ui/TranslucentValidationUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.jdesktop.jxlayer.JXLayer;
import org.nuiton.validator.NuitonValidatorScope;

import javax.swing.JComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

/**
 * An implementation of {@link AbstractBeanValidatorUI} which paints a
 * translucent backgroud color (green for ok, red for error, yellow for
 * warning).
 *
 * @author tchemit <chemit@codelutin.com>
 */
public class TranslucentValidationUI extends AbstractBeanValidatorUI {

    private static final long serialVersionUID = 1L;

    public TranslucentValidationUI(String field) {
        super(field);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        // paints the layer as is
        super.paintLayer(g2, l);

        // to be in sync with the view if the layer has a border
        Insets layerInsets = l.getInsets();
        g2.translate(layerInsets.left, layerInsets.top);

        JComponent view = l.getView();
        // To prevent painting on view's border
        Insets insets = view.getInsets();
        g2.clip(new Rectangle(insets.left, insets.top,
                              view.getWidth() - insets.left - insets.right,
                              view.getHeight() - insets.top - insets.bottom));

        NuitonValidatorScope scope = getScope();

        Color c = scope == null ? Color.WHITE : SwingValidatorUtil.getColor(scope);
        g2.setColor(c);
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, .2f));
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
    }
}
