/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected Color currentColor;
    protected JButton button = new JButton();
    protected JColorChooser colorChooser;
    protected JDialog dialog;
    protected static final String EDIT = "edit";

    public ColorCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "", true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Color getCellEditorValue() {
        return this.currentColor;
    }

    protected static String toHex(int r, int g, int b) {
        return "#" + ColorCellEditor.toBrowserHexValue(r) + ColorCellEditor.toBrowserHexValue(g) + ColorCellEditor.toBrowserHexValue(b);
    }

    protected static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentColor = (Color)value;
        return this.button;
    }
}

