/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: JAXXHelpUI.java 2289 2011-07-31 21:32:29Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.13/jaxx-runtime/src/main/java/jaxx/runtime/swing/help/JAXXHelpUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.help;

import java.awt.Component;

/**
 * Contract to be added on JAXXObject which wants to use javax help.
 *
 * @param <B> type of broker.
 * @author tchemit <chemit@codelutin.com>
 * @see JAXXHelpBroker
 * @since 1.3
 */
public interface JAXXHelpUI<B extends JAXXHelpBroker> {

    B getBroker();

    void registerHelpId(B broker, Component component, String helpId);

    void showHelp(String helpId);
}
