/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import jaxx.runtime.swing.model.JaxxDefaultComboBoxModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.JXPathDecorator;

public class JaxxFilterableComboBoxModel<E>
extends JaxxDefaultComboBoxModel<E> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JaxxFilterableComboBoxModel.class);
    public static final Character DEFAULT_WILDCARD_CHARACTER = Character.valueOf('*');
    protected List<E> filteredItems = Lists.newArrayList();
    protected String filterText;
    protected String previousFilterText;
    protected Character wildcardCharacter = DEFAULT_WILDCARD_CHARACTER;
    protected JXPathDecorator<E> decorator;
    protected List<Predicate<E>> filters = Lists.newArrayList();

    public JaxxFilterableComboBoxModel() {
    }

    public JaxxFilterableComboBoxModel(E ... items) {
        this.delegate = new ArrayList(items.length);
        int c = items.length;
        for (int i = 0; i < c; ++i) {
            this.delegate.add(items[i]);
        }
    }

    public JaxxFilterableComboBoxModel(Collection<E> v) {
        this.delegate = new ArrayList<E>(v);
    }

    @Override
    public int getIndexOf(E anObject) {
        return this.filteredItems.indexOf(anObject);
    }

    @Override
    public void addAllElements(Collection<E> objects) {
        super.addAllElements(objects);
        this.refilter();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.refilter();
    }

    @Override
    public int getSize() {
        return this.filteredItems.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getElementAt(int index) {
        E result;
        JaxxFilterableComboBoxModel jaxxFilterableComboBoxModel = this;
        synchronized (jaxxFilterableComboBoxModel) {
            result = index >= 0 && index < this.filteredItems.size() ? (E)this.filteredItems.get(index) : null;
        }
        return result;
    }

    @Override
    public void addElement(Object anObject) {
        super.addElement(anObject);
        this.refilter();
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        super.insertElementAt(anObject, index);
        this.refilter();
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.refilter();
    }

    @Override
    public void removeElement(Object anObject) {
        super.removeElement(anObject);
        this.refilter();
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        this.previousFilterText = this.filterText;
        this.filterText = filterText;
        this.refilter();
    }

    public Character getWildcardCharacter() {
        return this.wildcardCharacter;
    }

    public void setWildcardCharacter(Character wildcardCharacter) {
        this.wildcardCharacter = wildcardCharacter;
        this.refilter();
    }

    public JXPathDecorator<E> getDecorator() {
        return this.decorator;
    }

    public void setDecorator(JXPathDecorator<E> decorator) {
        this.decorator = decorator;
    }

    public void addFilter(Predicate<E> filter) {
        this.filters.add(filter);
        this.refilter();
    }

    public void removeFilter(Predicate<E> filter) {
        this.filters.remove(filter);
        this.refilter();
    }

    public void clearFilters() {
        this.filters.clear();
        this.refilter();
    }

    public void refreshFilteredElements() {
        this.refilter();
    }

    protected void refilter() {
        if (StringUtils.isNotBlank((CharSequence)this.filterText) && this.filterText.startsWith(this.previousFilterText) && !this.filteredItems.isEmpty()) {
            List<E> previousFilteredItems = this.filteredItems;
            this.filteredItems.clear();
            this.filteredItems = this.filter(previousFilteredItems, this.filterText);
        } else {
            this.filteredItems.clear();
            if ((StringUtils.isEmpty((CharSequence)this.filterText) || this.wildcardCharacter != null && StringUtils.isEmpty((CharSequence)StringUtils.remove((String)this.filterText, (char)this.wildcardCharacter.charValue()))) && this.filters.isEmpty()) {
                this.filteredItems.addAll(this.delegate);
            } else {
                this.filteredItems = this.filter(this.delegate, this.filterText);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("After refilter, nb items: " + this.getSize()));
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    protected List<E> filter(List<E> fromList, String filterText) {
        ArrayList<E> filteredItems = new ArrayList<E>();
        Pattern pattern = null;
        if (!StringUtils.isBlank((CharSequence)filterText)) {
            String patternText = Pattern.quote(filterText);
            patternText = this.wildcardCharacter == null ? ".*" + patternText : patternText.replace(this.wildcardCharacter.toString(), "\\E.*\\Q");
            pattern = Pattern.compile(patternText + ".*", 2);
        }
        for (E element : fromList) {
            boolean addElement = true;
            for (Predicate<E> filter : this.filters) {
                addElement &= filter.apply(element);
            }
            String decoratedElement = this.decorator != null ? this.decorator.toString(element) : String.valueOf(element);
            boolean matches = pattern == null || pattern.matcher(decoratedElement).matches();
            if (!matches || !addElement) continue;
            filteredItems.add(element);
        }
        return filteredItems;
    }
}

