/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: EnumEditor.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/editor/EnumEditor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/* 
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%* */package jaxx.runtime.swing.editor;

import javax.swing.JComboBox;
import java.util.EnumSet;
import java.util.Iterator;

import org.nuiton.util.ReflectUtil;

/**
 * Une éditeur d'enum.
 *
 * @param <E> le type d'enumeration a editer.
 * 
 * @author tchemit <chemit@codelutin.com>
 *
 * @since 1.6.0
 */
public class EnumEditor<E extends Enum<E>> extends JComboBox {

    private static final long serialVersionUID = 2L;
    /**
     * Type of enumeration
     */
    protected Class<E> type;

    /**
     * Creates a {@link EnumEditor} for the given enumeration {@code type}, with
     * all values of enumeration.
     *
     * @param type type of enumeration
     * @param <E> generci type of enumeration
     * @return the instanciated editor
     */
    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type) {
        return new EnumEditor<E>(type);
    }


    /**
     * Creates a {@link EnumEditor} for the given enumeration {@code type}, with
     * all values of enumeration which {@code ordinal} is strictly lower than
     * the given {@code maxOrdinal}.
     *
     * @param type type of enumeration
     * @param maxOrdinal the upper (strict) bound of ordinal values allowed
     * @param <E> generic type of enumeration
     * @return the instanciated editor
     */
    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type,
                                                              int maxOrdinal) {
        return new EnumEditor<E>(type, maxOrdinal);
    }

    /**
     * Creates a {@link EnumEditor} for the given enumeration {@code type}, with
     * all given {@code universe} values of enumeration.
     *
     * @param universe enumerations to put in editor
     * @param <E> generci type of enumeration
     * @return the instanciated editor
     */
    public static <E extends Enum<E>> EnumEditor<E> newEditor(E... universe) {
        return new EnumEditor<E>(universe);
    }

    public EnumEditor(Class<E> type) {
        super(buildModel(type));
    }

    public EnumEditor(Class<E> type, int maxOrdinal) {
        super(buildModel(type, maxOrdinal));
    }

    public EnumEditor(E... universe) {
        super(universe);
    }

    @Override
    public E getSelectedItem() {
        return (E) super.getSelectedItem();
    }

    protected static <E extends Enum<E>> Object[] buildModel(Class<E> type) {
        Class<E> enumClass = ReflectUtil.getEnumClass(type);
        EnumSet<E> result = EnumSet.allOf(enumClass);
        return result.toArray(new Object[result.size()]);
    }


    protected static <E extends Enum<E>> Object[] buildModel(Class<E> type,
                                                             int maxOrdinal) {
        Class<E> enumClass = ReflectUtil.getEnumClass(type);
        EnumSet<E> result = EnumSet.allOf(enumClass);
        Iterator<E> itr = result.iterator();
        while (itr.hasNext()) {
            E e = itr.next();
            if (e.ordinal() > maxOrdinal) {
                itr.remove();
            }
        }
        return result.toArray(new Object[result.size()]);
    }
}
