/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationContextHelper;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.tree.NavigationTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;

public abstract class AbstractNavigationHelper<E extends NavigationNode<E>>
extends NavigationContextHelper<E> {
    private static final Log log = LogFactory.getLog(NavigationTreeHelper.class);

    public abstract NavigationModel<E> createTreeModel(JAXXContext var1);

    public abstract NavigationHandler<E> createTreeHandler(JAXXObject var1);

    public AbstractNavigationHelper(String contextPrefix) {
        super(contextPrefix);
    }

    public Object getContextValue(JAXXContext context, String path) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        NavigationModel<E> treeModel = this.getSafeModel(context);
        return treeModel.getBean(path);
    }

    public E findNode(JAXXContext context, String path) {
        NavigationModel<E> treeModel = this.getSafeModel(context);
        return treeModel.findNode(path);
    }

    public E findNode(JAXXContext context, String path, String regex) {
        NavigationModel<String> treeModel = this.getSafeModel(context);
        return (E)treeModel.findNode(path, regex);
    }

    public E findNode(JAXXContext context, String path, Pattern regex) {
        NavigationModel<E> treeModel = this.getSafeModel(context);
        return treeModel.findNode(path, regex);
    }

    public E findNode(JAXXContext context, String path, String regex, String suffix) {
        NavigationModel<String> treeModel = this.getSafeModel(context);
        String node = treeModel.findNode(path, regex);
        if (node != null && suffix != null) {
            node = treeModel.findNode(node, suffix);
        }
        return (E)node;
    }

    public E findNode(JAXXContext context, String path, Pattern regex, String suffix) {
        NavigationModel<E> treeModel = this.getSafeModel(context);
        E node = treeModel.findNode(path, regex);
        if (node != null && suffix != null) {
            node = treeModel.findNode(node, suffix);
        }
        return node;
    }

    public void selectNode(JAXXContext context, String path) {
        E node = this.findNode(context, path);
        if (log.isDebugEnabled()) {
            log.debug((Object)(path + " :: " + node));
        }
        if (node != null) {
            this.selectNode(context, node);
        }
    }

    public void selectNode(JAXXContext context, E node) {
        NavigationModel<E> navigationModel = this.getSafeModel(context);
        if (log.isDebugEnabled()) {
            log.debug(node);
        }
        TreePath path = new TreePath(navigationModel.getPathToRoot((NavigationNode)node));
        JTree tree = this.getTree(context);
        if (tree == null) {
            JXTreeTable treeTable = this.getSafeTreeTable(context);
            treeTable.getTreeSelectionModel().setSelectionPath(path);
            treeTable.scrollPathToVisible(path);
            return;
        }
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public void gotoParentNode(JAXXContext context) {
        Object node = this.getSelectedNode(context);
        if (node == null) {
            throw new NullPointerException("no selected node in context");
        }
        node = node.getParent();
        this.selectNode(context, node);
    }

    public E getParentNode(E current, Class<?> beanClass) {
        if (current == null) {
            return null;
        }
        if (beanClass.isAssignableFrom(current.getInternalClass())) {
            return current;
        }
        return this.getParentNode(current.getParent(), beanClass);
    }

    public void gotoChildNode(JAXXContext context, int childIndex) {
        Object node = this.getSelectedNode(context);
        if (node == null) {
            throw new NullPointerException("no selected node in context");
        }
        node = node.getChildAt(childIndex);
        this.selectNode(context, node);
    }

    public void repaintNode(JAXXContext context, E node) {
        this.repaintNode(context, node, false);
    }

    public void repaintNode(JAXXContext context, E node, boolean deep) {
        NavigationModel<E> navigationModel = this.getSafeModel(context);
        if (log.isDebugEnabled()) {
            log.debug(node);
        }
        navigationModel.nodeChanged(node);
        if (deep) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                NavigationNode child = (NavigationNode)e.nextElement();
                this.repaintNode(context, child, true);
            }
        }
    }

    public NavigationModel<E> getSafeModel(JAXXContext context) throws NullPointerException {
        NavigationModel model = this.getModel(context);
        if (model == null) {
            throw new NullPointerException("could not find tree model with key " + this.getModelContextEntry() + " in context " + context);
        }
        return model;
    }

    public JTree getSafeTree(JAXXContext context) throws NullPointerException {
        JTree tree = this.getTree(context);
        if (tree == null) {
            throw new NullPointerException("could not find tree with key " + this.getTreeContextEntry() + " in context " + context);
        }
        return tree;
    }

    public JXTreeTable getSafeTreeTable(JAXXContext context) throws NullPointerException {
        JXTreeTable treeTable = this.getTreeTable(context);
        if (treeTable == null) {
            throw new NullPointerException("could not find tree with key " + this.getTreeTableContextEntry() + " in context " + context);
        }
        return treeTable;
    }
}

