/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationNodeRendererI18nImpl.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/NavigationNodeRendererI18nImpl.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;

import static org.nuiton.i18n.I18n._;

/**
 * I18n label Renderer of a {@link NavigationTreeNode}.
 * <p/>
 * Just apply a i18n translation on the given {@link #libelle}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2, replace {@code NavigationUtil#NodeRenderer} which disappear
 *        soon...
 */
public class NavigationNodeRendererI18nImpl implements NavigationNodeRenderer {

    private static final long serialVersionUID = -1L;

    /** Static i18n label to render */
    protected final String libelle;

    /** internal class of representing data */
    protected final Class<?> internalClass;

    /** last renderered value */
    protected String text;

    public NavigationNodeRendererI18nImpl(String libelle) {
        this.libelle = libelle;
        internalClass = String.class;
    }

    @Override
    public String toString() {
        return text;
    }

    @Override
    public void reload(Object data) {
        text = _(libelle);
    }

    @Override
    public Class<?> getInternalClass() {
        return internalClass;
    }
}
