package jaxx.runtime.swing.navigation;

import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;

import java.io.Serializable;
import java.util.Enumeration;

/**
 * Contract of a navigation node.
 *
 * @author tchemit <chemit@codelutin.com>
 * @param <E> type of the node
 * @since 2.0.1
 */
public interface NavigationNode<E extends NavigationNode<E>> extends Cloneable, Serializable {

    NavigationNodeRenderer getRenderer();

    String getPathSeparator();

    String getNodePath();

    Class<? extends JAXXObject> getUIClass();

    Class<? extends JAXXAction> getUIHandlerClass();

    JAXXContextEntryDef<?> getJaxxContextEntryDef();

    String getJaxxContextEntryPath();

    Class<?> getInternalClass();

    String getFullPath();

    E getChildAt(int index);

    E getParent();

    E getChild(String path);

    Object getBean();

    Object getBean(JAXXContext context);

    int getChildCount();

    int getIndex(E node);

    boolean getAllowsChildren();

    boolean isLeaf();

    Enumeration<? extends E> children();

    boolean isRoot();

    Object getUserObject();

    E[] getPathToRoot(E aNode, int depth);

    E[] getPath();

    void setRenderer(NavigationNodeRenderer renderer);

    void setNodePath(String navigationPath);

    void setUIClass(Class<? extends JAXXObject> uIClass);

    void setInternalClass(Class<?> internalClass);

    void setUIHandlerClass(Class<? extends JAXXAction> uIHandlerClass);

    void setJaxxContextEntryDef(JAXXContextEntryDef<?> jaxxContextEntryDef);

    void setJaxxContextEntryPath(String jaxxContextEntryPath);

    void setParent(E newParent);

    void setBean(Object bean);

    void setUserObject(Object object);

    void reload(JAXXContext context);

    void add(E node);

    void insert(E child, int index);

    void remove(int index);

    void remove(E node);

    void removeFromParent();

}
