/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.validator.BeanValidatorScope;
import org.jdesktop.jxlayer.JXLayer;

import javax.swing.JComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import jaxx.runtime.validator.BeanValidatorField;

/** @author chemit */
public class TranslucentValidationUI extends AbstractBeanValidatorUI {

    protected Color errorHightlight;
    protected Color warningHightlight;
    protected Color infoHightlight;

    public TranslucentValidationUI(BeanValidatorField<?> field) {
        super(field);
        errorHightlight = Color.RED;
        warningHightlight = Color.YELLOW;
        infoHightlight = Color.GREEN;
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        // paints the layer as is
        super.paintLayer(g2, l);

        // to be in sync with the view if the layer has a border
        Insets layerInsets = l.getInsets();
        g2.translate(layerInsets.left, layerInsets.top);

        JComponent view = l.getView();
        // To prevent painting on view's border
        Insets insets = view.getInsets();
        g2.clip(new Rectangle(insets.left, insets.top,
                view.getWidth() - insets.left - insets.right,
                view.getHeight() - insets.top - insets.bottom));

        BeanValidatorScope scope = field.getScope();

        if (scope == null) {
            g2.setColor(Color.WHITE);
        } else {
            switch (scope) {
                case ERROR:
                    g2.setColor(errorHightlight);
                    break;
                case WARNING:
                    g2.setColor(warningHightlight);
                    break;
                case INFO:
                    g2.setColor(infoHightlight);
                    break;
            }
        }
        
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, .2f));
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
    }
}
