/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import jaxx.runtime.Util;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import org.jdesktop.jxlayer.JXLayer;

public class ImageValidationUI
extends AbstractBeanValidatorUI {
    protected static BufferedImage errorIcon;
    protected static BufferedImage warningIcon;
    protected static BufferedImage infoIcon;

    public ImageValidationUI(BeanValidatorField field) {
        super(field);
        if (errorIcon == null) {
            errorIcon = ImageValidationUI.prepareIcon(Util.createImageIcon((String)"error.png"));
        }
        if (warningIcon == null) {
            warningIcon = ImageValidationUI.prepareIcon(Util.createImageIcon((String)"warning.png"));
        }
        if (infoIcon == null) {
            infoIcon = ImageValidationUI.prepareIcon(Util.createImageIcon((String)"info.png"));
        }
    }

    protected static BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        BeanValidatorScope scope = this.field.getScope();
        if (scope != null) {
            BufferedImage icon = null;
            switch (scope) {
                case ERROR: {
                    icon = errorIcon;
                    break;
                }
                case WARNING: {
                    icon = warningIcon;
                    break;
                }
                case INFO: {
                    icon = infoIcon;
                }
            }
            if (icon != null) {
                g2.drawImage((Image)icon, l.getWidth() - icon.getWidth() - 1, 0, null);
            }
        }
    }
}

