/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.swing.Item;

public class JAXXList
extends JList {
    private static final long serialVersionUID = 1L;

    public JAXXList() {
        this.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Item item;
                String label;
                ListModel model = list.getModel();
                if (model instanceof JAXXListModel && (label = (item = (Item)((JAXXListModel)model).items.get(index)).getLabel()) != null) {
                    value = label;
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListModel model = JAXXList.this.getModel();
                if (model instanceof JAXXListModel) {
                    List items = ((JAXXListModel)model).items;
                    for (int i = items.size() - 1; i >= 0; --i) {
                        Item item;
                        boolean selected = JAXXList.this.isSelectedIndex(i);
                        if (selected == (item = (Item)items.get(i)).isSelected()) continue;
                        item.setSelected(selected);
                    }
                }
            }
        });
    }

    @Override
    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        super.fireSelectionValueChanged(firstIndex, lastIndex, isAdjusting);
    }

    public void setSelectedValue(Object value) {
        super.setSelectedValue(value, true);
    }

    public void setItems(List<Item> items) {
        this.setModel(new JAXXListModel(items));
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            if (!items.get(i).isSelected()) continue;
            selectedIndexList.add(i);
        }
        int[] selectedIndices = new int[selectedIndexList.size()];
        for (int i = 0; i < selectedIndexList.size(); ++i) {
            selectedIndices[i] = (Integer)selectedIndexList.get(i);
        }
        this.setSelectedIndices(selectedIndices);
    }

    public void fillList(Collection<?> data, Collection<?> selects) {
        if (selects == null) {
            selects = Collections.EMPTY_LIST;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            Object select;
            boolean selected = false;
            Iterator i$ = selects.iterator();
            while (i$.hasNext() && !(selected = o.equals(select = i$.next()))) {
            }
            items.add(new Item(o.toString(), o.toString(), o, selected));
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Object select) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = o.equals(select);
            items.add(new Item(o.toString(), o.toString(), o, selected));
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Object select, String methodName) {
        Method m = null;
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = o.equals(select);
            if (m == null) {
                try {
                    m = o.getClass().getMethod(methodName, new Class[0]);
                    m.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("could not find method " + methodName + " on " + o.getClass());
                }
            }
            try {
                items.add(new Item(o.toString(), (String)m.invoke(o, new Object[0]), o, selected));
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Collection<?> selects, String methodName) {
        Method m = null;
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = selects.contains(o);
            if (m == null) {
                try {
                    m = o.getClass().getMethod(methodName, new Class[0]);
                    m.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("could not find method " + methodName + " on " + o.getClass());
                }
            }
            try {
                items.add(new Item(o.toString(), (String)m.invoke(o, new Object[0]), o, selected));
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.setItems(items);
    }

    public void setSelectedValues(Object[] values) {
        if (values != null) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            ListModel model = this.getModel();
            block0: for (int i = 0; i < model.getSize(); ++i) {
                Object o = model.getElementAt(i);
                for (Object value : values) {
                    if (!o.equals(value)) continue;
                    selectedIndices.add(i);
                    continue block0;
                }
            }
            int[] ints = new int[selectedIndices.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = (Integer)selectedIndices.get(i);
            }
            this.setSelectedIndices(ints);
        } else {
            this.setSelectedIndex(-1);
        }
    }

    public class JAXXListModel
    extends AbstractListModel {
        private List<Item> items;
        private static final long serialVersionUID = -1598924187490122036L;

        public JAXXListModel(List<Item> items) {
            this.items = items;
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("selected")) {
                        int[] newSelection;
                        Item item = (Item)e.getSource();
                        int itemIndex = JAXXListModel.this.items.indexOf(item);
                        int[] oldSelection = JAXXList.this.getSelectedIndices();
                        int index = -1;
                        for (int i = 0; i < oldSelection.length; ++i) {
                            if (oldSelection[i] != itemIndex) continue;
                            index = i;
                            break;
                        }
                        if (item.isSelected()) {
                            if (index != -1) {
                                return;
                            }
                            newSelection = new int[oldSelection.length + 1];
                            System.arraycopy(oldSelection, 0, newSelection, 0, oldSelection.length);
                            newSelection[newSelection.length - 1] = itemIndex;
                        } else {
                            if (index == -1) {
                                return;
                            }
                            newSelection = new int[oldSelection.length - 1];
                            System.arraycopy(oldSelection, 0, newSelection, 0, index);
                            System.arraycopy(oldSelection, index + 1, newSelection, index, oldSelection.length - 1 - index);
                        }
                        JAXXList.this.setSelectedIndices(newSelection);
                    } else {
                        for (int i = 0; i < JAXXListModel.this.getSize(); ++i) {
                            if (JAXXListModel.this.getElementAt(i) != ((Item)e.getSource()).getValue()) continue;
                            JAXXListModel.this.fireContentsChanged(JAXXListModel.this, i, i);
                            if (JAXXList.this.isSelectedIndex(i)) {
                                JAXXList.this.fireSelectionValueChanged(i, i, false);
                            }
                            return;
                        }
                    }
                }
            };
            for (Item item : items) {
                item.addPropertyChangeListener(listener);
            }
        }

        @Override
        public Object getElementAt(int i) {
            return this.items.get(i).getValue();
        }

        @Override
        public int getSize() {
            return this.items.size();
        }
    }
}

