/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JaxxHelpBroker<B extends JaxxHelpBroker<?>> {
    public static final String JAXX_CONTEXT_ENTRY = "jaxxcontext";
    private static Log log = LogFactory.getLog(JaxxHelpBroker.class);
    protected final String helpsetName;
    protected final String defaultID;
    protected final String helpKey;
    protected final HelpSet helpset;
    protected final HelpBroker helpBroker;
    protected Hashtable<Component, Cursor> cursors;
    protected Cursor onItemCursor;
    protected final Map<Component, String> cache;

    protected JaxxHelpBroker(String helpsetName, String helpKey, String defaultID) {
        if (helpsetName == null) {
            throw new NullPointerException("parameter helpsetName can not be null!");
        }
        this.helpsetName = helpsetName;
        this.helpKey = helpKey;
        this.defaultID = defaultID;
        this.cache = new HashMap<Component, String>();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            this.helpset = new HelpSet(cl, url);
            this.helpBroker = this.helpset.createHelpBroker();
        }
        catch (Exception ee) {
            throw new IllegalStateException("could not find help set " + helpsetName + " for reason " + ee.getMessage(), ee);
        }
    }

    public void prepareUI(JAXXObject c) {
        if (c == null) {
            throw new NullPointerException("parameter c can not be null!");
        }
        AbstractButton help = this.getShowHelpButton(c);
        if (help == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no showButton detected for " + c.getClass()));
            }
        } else {
            help.putClientProperty(JAXX_CONTEXT_ENTRY, c.getDelegateContext());
            ActionListener listener = this.getShowHelpAction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding tracking action " + listener));
            }
            help.addActionListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("done for " + c));
        }
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public String getHelpKey() {
        return this.helpKey;
    }

    public HelpSet getHelpset() {
        return this.helpset;
    }

    public String getHelpsetName() {
        return this.helpsetName;
    }

    public String getDefaultID() {
        return this.defaultID;
    }

    public void showHelpSet() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        new CSH.DisplayHelpFromSource(this.helpBroker);
    }

    public void showHelp(JAXXContext context, String helpId) {
    }

    public void installUI(Component comp, String helpId) {
        CSH.setHelpIDString((Component)comp, (String)helpId);
        if (log.isDebugEnabled()) {
            log.debug((Object)(helpId + " : " + comp.getName()));
        }
        this.cache.put(comp, helpId);
    }

    protected AbstractButton getShowHelpButton(JAXXObject c) {
        return (AbstractButton)c.getObjectById("showHelp");
    }

    protected ActionListener getShowHelpAction() {
        return new ShowHelpForTrackedComponentAction();
    }

    protected Vector<?> getTopContainers(Object source) {
        Vector<Component> containers = new Vector<Component>();
        Component topComponent = null;
        topComponent = this.getRoot(source);
        if (topComponent instanceof Applet) {
            try {
                Enumeration<Applet> applets = ((Applet)topComponent).getAppletContext().getApplets();
                while (applets.hasMoreElements()) {
                    containers.add(applets.nextElement());
                }
            }
            catch (NullPointerException npe) {
                containers.add(topComponent);
            }
        }
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            Window[] windows = frames[i].getOwnedWindows();
            for (int j = 0; j < windows.length; ++j) {
                containers.add(windows[j]);
            }
            if (containers.contains(frames[i])) continue;
            containers.add(frames[i]);
        }
        return containers;
    }

    protected Component getRoot(Object comp) {
        Object parent = comp;
        while (parent != null) {
            comp = parent;
            if (comp instanceof MenuComponent) {
                parent = ((MenuComponent)comp).getParent();
                continue;
            }
            if (!(comp instanceof Component) || comp instanceof Window || comp instanceof Applet) break;
            parent = ((Component)comp).getParent();
        }
        if (comp instanceof Component) {
            return (Component)comp;
        }
        return null;
    }

    protected void setAndStoreCursors(Component comp, Cursor cursor) {
        if (comp == null) {
            return;
        }
        Cursor compCursor = comp.getCursor();
        if (compCursor != cursor) {
            this.cursors.put(comp, compCursor);
            log.debug((Object)("set cursor on " + comp));
            comp.setCursor(cursor);
        }
        if (comp instanceof Container) {
            Component[] component = ((Container)comp).getComponents();
            for (int i = 0; i < component.length; ++i) {
                this.setAndStoreCursors(component[i], cursor);
            }
        }
    }

    protected void resetAndRestoreCursors(Component comp) {
        if (comp == null) {
            return;
        }
        Cursor oldCursor = this.cursors.get(comp);
        if (oldCursor != null) {
            log.debug((Object)("restored cursor " + oldCursor + " on " + comp));
            comp.setCursor(oldCursor);
        }
        if (comp instanceof Container) {
            Component[] component = ((Container)comp).getComponents();
            for (int i = 0; i < component.length; ++i) {
                this.resetAndRestoreCursors(component[i]);
            }
        }
    }

    public static MouseEvent getMouseEvent() {
        block18: {
            try {
                if (!EventQueue.isDispatchThread()) break block18;
                EventQueue eq = null;
                try {
                    eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception ee) {
                    log.debug((Object)ee);
                }
                if (eq == null) {
                    return null;
                }
                int eventNumber = -1;
                while (true) {
                    ++eventNumber;
                    AWTEvent event = eq.getNextEvent();
                    Object src = event.getSource();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)event);
                    }
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (src instanceof Component) {
                        InputEvent e;
                        if (event instanceof KeyEvent) {
                            e = (KeyEvent)event;
                            if (((KeyEvent)e).getKeyCode() == 3 || ((KeyEvent)e).getKeyCode() == 27) {
                                e.consume();
                                return null;
                            }
                            e.consume();
                            continue;
                        }
                        if (event instanceof MouseEvent) {
                            e = (MouseEvent)event;
                            int eID = e.getID();
                            if ((eID == 500 || eID == 501 || eID == 502) && SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                                e.consume();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"tracking canceled!!!");
                                }
                                return null;
                            }
                            if ((eID == 500 || eID == 501 || eID == 502) && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                                if (eID == 500 && eventNumber == 0) {
                                    JaxxHelpBroker.dispatchEvent(event);
                                    continue;
                                }
                                e.consume();
                                return e;
                            }
                            e.consume();
                            continue;
                        }
                        JaxxHelpBroker.dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        if (!(event instanceof InputEvent)) continue;
                        ((InputEvent)event).consume();
                        continue;
                    }
                    log.error((Object)("unable to dispatch event: " + event));
                }
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Fall Through code");
        }
        return null;
    }

    private static void dispatchEvent(AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else {
            log.error((Object)("unable to dispatch event: " + event));
        }
    }

    public class ShowHelpForTrackedComponentAction
    implements ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton source = (AbstractButton)e.getSource();
            JAXXContext context = (JAXXContext)source.getClientProperty(JaxxHelpBroker.JAXX_CONTEXT_ENTRY);
            JaxxHelpBroker.this.onItemCursor = (Cursor)UIManager.get("HelpOnItemCursor");
            Vector<?> topComponents = null;
            JaxxHelpBroker.this.cursors = null;
            if (JaxxHelpBroker.this.onItemCursor != null) {
                JaxxHelpBroker.this.cursors = new Hashtable();
                topComponents = JaxxHelpBroker.this.getTopContainers(source);
                Enumeration<?> enums = topComponents.elements();
                while (enums.hasMoreElements()) {
                    JaxxHelpBroker.this.setAndStoreCursors((Container)enums.nextElement(), JaxxHelpBroker.this.onItemCursor);
                }
            }
            Component comp = null;
            try {
                MouseEvent event = JaxxHelpBroker.getMouseEvent();
                if (event == null) {
                    return;
                }
                comp = (Component)event.getSource();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("component traking " + comp.getName() + " : " + comp.getClass().getName()));
                }
                comp = SwingUtil.getDeepestObjectAt(comp, event.getX(), event.getY());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deepest component " + comp.getName() + " : " + comp.getClass().getName()));
                }
            }
            finally {
                if (topComponents != null) {
                    Enumeration<?> containers = topComponents.elements();
                    while (containers.hasMoreElements()) {
                        JaxxHelpBroker.this.resetAndRestoreCursors((Container)containers.nextElement());
                    }
                }
                JaxxHelpBroker.this.cursors = null;
            }
            String helpID = this.findHelpId(comp);
            JaxxHelpBroker.this.showHelp(context, helpID);
        }

        public String findHelpId(Component comp) {
            String helpID = CSH.getHelpIDString((Component)comp);
            if (JaxxHelpBroker.this.defaultID.equals(helpID)) {
                String id = JaxxHelpBroker.this.cache.get(comp);
                if (helpID.equals(id)) {
                    return helpID;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will try to find better id for comp : " + comp.getName()));
                }
                helpID = this.findExtactHelpId(comp);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("helpID " + helpID + " for comp " + comp.getName() + " : " + comp.getClass().getName()));
            }
            return helpID;
        }

        protected String findExtactHelpId(Component comp) {
            for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
                String id = JaxxHelpBroker.this.cache.get(parent);
                if (id == null) {
                    continue;
                }
                return id;
            }
            return JaxxHelpBroker.this.defaultID;
        }
    }
}

