package jaxx.runtime.swing.wizard;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import org.apache.commons.logging.Log;

/**
 * Classe de méthodes utiles sur les wizard.
 *
 * @author tony
 * @since 1.3
 */
public class WizardUtil {

    protected WizardUtil() {
    }

    public static boolean acceptStates(WizardOperationState state, WizardOperationState... accepted) {
        for (WizardOperationState s : accepted) {
            if (s == state) {
                return true;
            }
        }
        return false;
    }

    public static boolean rejectStates(WizardOperationState state, WizardOperationState... rejected) {
        for (WizardOperationState s : rejected) {
            if (s == state) {
                return false;
            }
        }
        return true;
    }

    public static void addDebugLogListener(final Log log, WizardModel model) {
        if (log.isDebugEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.debug(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">");
                }
            });
        }
    }

    public static void addTraceLogListener(final Log log, WizardModel model) {
        if (log.isTraceEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.trace(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">");
                }
            });
        }
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void installWizardUIListeners(final WizardUI<E, M> ui) {
        ui.getModel().addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            @SuppressWarnings("unchecked")
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (WizardOperationModel.WAS_STARTED_PROPERTY_NAME.equals(propertyName)) {
                    ui.onWasStarted();
                    return;
                }
                if (WizardModel.STEPS_PROPERTY_NAME.equals(propertyName)) {
                    java.util.List<E> steps = (java.util.List<E>) evt.getNewValue();
                    ui.onStepsChanged(steps.toArray((E[]) Array.newInstance(ui.getModel().stepClass, steps.size())));
                    return;
                }
                if (WizardModel.STEP_PROPERTY_NAME.equals(propertyName)) {
                    ui.onStepChanged((E) evt.getNewValue());
                    return;
                }
                if (WizardOperationModel.MODEL_STATE_PROPERTY_NAME.equals(propertyName)) {
                    //TODO should be unicast : only for good stepUI ?
                    ui.onModelStateChanged((WizardOperationState) evt.getNewValue());
                    return;
                }
                if (WizardOperationModel.OPERATION_STATE_PROPERTY_NAME.equals(propertyName)) {
                    IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent) evt;
                    int stepIndex = e.getIndex();
                    E step = ui.getModel().getSteps().get(stepIndex);
                    ui.onOperationStateChanged(step, (WizardOperationState) evt.getNewValue());
                    return;
                }
            }
        });
    }
}
