package jaxx.runtime.swing.wizard;

/**
 *
 * Le contrat a implanter pour une etapes dans le modèle de wizard avec
 * opérations.
 * 
 * @author tony
 * @since 1.3
 */
public interface WizardOperationStep extends WizardStep {

    /**
     * @return le label de l'opération
     */
    String getOperationLabel();

    /**
     * @return la description de l'opération
     */
    String getOperationDescription();

    /**
     * @return le type de l'action associée à l'étape ou <code>null</code> si
     *         l'étape n'a pas d'opération associée.
     */
    Class<? extends WizardOperationAction> getActionClass();

    /**
     * @return <code>true</code> si l'étape a une opération associée,
     *         <code>false</code> sinon.
     */
    boolean isOperation();
}
