/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.LocaleListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class I18nEditor
extends JPanel
implements PropertyChangeListener,
ActionListener,
JAXXObject {
    public static final Log log = LogFactory.getLog(I18nEditor.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRgeKm1pgQqCJCYaPsREL1s9GD9AUFAUUpTQxhB7cdod2yHDzjgzC4sHY+LVGE4evKh3j96N8ejJq//BGP+B78x2uy1UbKSHfrz7PM8877wf/fgTJZVEk5s4CBzpe5puEWfl1sbGg8omqerbRFUlFZpLFL56EihRRv1uM640OlsuGHq+Qc8v8i3BPeK1sGcKKKv0LiOqTojW6GTIqCqVLzbDM4HwZaTWNNNJ7f3vX4k998WHBEKBAFc5SGHiX6w4g94CSlBXoxNw0jbOM+zVwIakXg18DprYIsNK3cdb5Cl6jtIFlBJYgphGU92najUsPxAapavc01Zius2o2oFjHeJSoDrLl656d+xXISw1pdGIIgwqQdwS56xERYkEIDJkXDrGuRM6jwljHtfFgxzzNBej+lSd74Raw7HWAuAJ9vbBlsG7+T0SxwcEF754SBWtMLLvWZrxKoaaapSzyr6mzClQpWNILkqqYKFRPiHShloswM27RBKp0YUOVxfCjfwiYWy9gTXcTFMiad3C1ZhTggZxZc0EV4nnx2dlLbCAK4RBe7ShbdDAJpvoVMXXGsqKTrUhS7xWY2TBPmv3kabgLjA3M9UhEzN2Ieuu5GAqboHpom2uZY9qihl9RuRFjcatRBU6kDIinQMQ4Es0EoKUcuI5iwehp4yS0relGirHI7kOoXAYG1ErYKPvXr7dfvPp8/Vo8gbgjME2SMuigEkQkguoHDVHHA/HzRQ5v4rFTBllwjawW2S0xUCxEQYToD8c98Y9rOpATaZ/fPk69vj7MZRYQlnGsbuEDX4ZZXRdQpacuYGYv2mdDOz0wfuQ8QQlY3iXwx2j3KyLNZ6oQEXg7ucCSHa0Jdmmg297r1ZPvz5zJUq4JzS0DxYnnXyEUtRj1CN2yTT2R8el0i8U8V0e74lOm6PHfGajZrhs3691yqxtUmcD33zcsIbNt3mrM96tTrQwjqCTqnDphoP4F5WpLlTSxMOwYcyyng2vdQJrWHgweWSus+y5LmR7dSPB4v9rDDzhVV+tYQp73T1E63wXWhmrhRu79AhCvfTwDuhGoy9azkfSMeGNIzrp1+3/X4dI/QGDIcIHyQgAAA==";
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected JToggleButton button;
    protected I18nEditor content = this;
    protected final JAXXContext delegateContext = new DefaultJAXXContext((JAXXObject)this);
    protected JAXXButtonGroup indexes;
    protected List<Locale> locales;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected Boolean popupVisible;
    protected LocaleListCellRenderer renderer;
    protected Locale selectedLocale;
    protected String selectedToolTipText;
    protected Boolean showIcon;
    protected Boolean showText;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    Map $previousValues = new HashMap();
    private PropertyChangeListener $DataSource2 = new DataBindingListener((JAXXObject)this.content, "renderer.showIcon");
    private PropertyChangeListener $DataSource3 = new DataBindingListener((JAXXObject)this.content, "renderer.showText");
    private PropertyChangeListener $DataSource5 = new DataBindingListener((JAXXObject)this.content, "button.icon");
    private PropertyChangeListener $DataSource6 = new DataBindingListener((JAXXObject)this.content, "button.selected");
    private PropertyChangeListener $DataSource7 = new DataBindingListener((JAXXObject)this.content, "button.text");
    private PropertyChangeListener $DataSource8 = new DataBindingListener((JAXXObject)this.content, "button.toolTipText");
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n_((String)"i18neditor.selected");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n_((String)"i18neditor.unselected");
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    protected Runnable showPopupRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">"));
        }
        log.info((Object)(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">"));
        if (LOCALES_PROPERTY.equals(name)) {
            Locale oldLocale = this.getSelectedLocale();
            Collection newLocales = (Collection)evt.getNewValue();
            boolean oldShowText = this.renderer.isShowText();
            try {
                this.renderer.setShowText(true);
                this.popup.removeAll();
                for (Object o : newLocales) {
                    Locale l = (Locale)o;
                    boolean selected = l.equals(this.selectedLocale);
                    String text = this.renderer.getText(l);
                    Icon icon = this.renderer.getIcon(l);
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(text, icon, selected);
                    this.popup.add(b);
                    b.addActionListener(this);
                    b.putClientProperty("locale", l);
                    b.setToolTipText(this.getTip(l));
                    b.putClientProperty("$buttonGroup", this.getIndexes());
                    b.putClientProperty("$value", l);
                }
            }
            finally {
                this.renderer.setShowText(oldShowText);
                this.popup.invalidate();
            }
            return;
        }
        if (SHOW_ICON_PROPERTY.equals(name)) {
            this.renderer.setShowIcon(((Boolean)evt.getNewValue()).booleanValue());
            this.processDataBinding("button.icon");
            return;
        }
        if (SHOW_TEXT_PROPERTY.equals(name)) {
            this.renderer.setShowText(((Boolean)evt.getNewValue()).booleanValue());
            this.processDataBinding("button.text");
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean)evt.getNewValue();
            if (newValue == null || !newValue.booleanValue()) {
                if (this.getPopup() != null && this.getPopup().isVisible()) {
                    this.getPopup().setVisible(false);
                }
                return;
            }
            if (!this.getPopup().isVisible()) {
                SwingUtilities.invokeLater(this.showPopupRunnable);
            }
            return;
        }
        if (SELECTED_LOCALE_PROPERTY.equals(name)) {
            Locale newLocale = (Locale)evt.getNewValue();
            try {
                for (Component c : this.popup.getComponents()) {
                    if (!(c instanceof JRadioButtonMenuItem)) continue;
                    JRadioButtonMenuItem b = (JRadioButtonMenuItem)c;
                    Locale l = (Locale)b.getClientProperty("locale");
                    b.setSelected(newLocale.equals(l));
                }
            }
            finally {
                this.popup.invalidate();
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Locale value = (Locale)((JComponent)event.getSource()).getClientProperty("locale");
        if (log.isDebugEnabled()) {
            log.debug((Object)("new locale : " + value));
        }
        this.setSelectedLocale(value);
    }

    public void loadI18nBundles() {
        Locale[] locales = I18n.getLoader().getLocales();
        this.setLocales(Arrays.asList(I18n.getLoader().getLocales()));
    }

    protected String getTip(Locale l) {
        boolean selected = l.equals(this.selectedLocale);
        String tip = selected ? this.getSelectedTip(l) : this.getNotSelectedTip(l);
        return tip;
    }

    protected String getSelectedTip(Locale l) {
        String selectedTip = this.getSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        String tip = this.renderer.getToolTipText(l);
        tip = I18n._((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    protected String getNotSelectedTip(Locale l) {
        String selectedTip = this.getNotSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        String tip = this.renderer.getToolTipText(l);
        tip = I18n._((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public I18nEditor() {
        this.$initialize();
    }

    public I18nEditor(JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to((JAXXContext)this);
        } else {
            this.setContextValue(parentContext);
        }
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
            this.addPropertyChangeListener(SHOW_ICON_PROPERTY, this.$DataSource2);
        } else if ("renderer.showText".equals($binding)) {
            this.addPropertyChangeListener(SHOW_TEXT_PROPERTY, this.$DataSource3);
        } else if ("button.icon".equals($binding)) {
            this.addPropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource5);
        } else if ("button.selected".equals($binding)) {
            if (this.popup != null) {
                this.$bindingSources.put("popup", this.popup);
                this.popup.addComponentListener((ComponentListener)Util.getEventListener(ComponentListener.class, (Object)this.content, (String)"$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
            this.addPropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource7);
        } else if ("button.toolTipText".equals($binding)) {
            this.addPropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource8);
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        this.processDataBinding(dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && this.$activeBindings.contains($dest)) {
            return;
        }
        this.$activeBindings.add($dest);
        try {
            if ("renderer.showIcon".equals($dest)) {
                this.renderer.setShowIcon(this.isShowIcon().booleanValue());
            } else if ("renderer.showText".equals($dest)) {
                this.renderer.setShowText(this.isShowText().booleanValue());
            } else if ("button.icon".equals($dest)) {
                this.button.setIcon(this.renderer.getIcon(this.getSelectedLocale()));
            } else if ("button.selected".equals($dest)) {
                if (this.popup != null) {
                    this.button.setSelected(this.popup.isVisible());
                }
            } else if ("button.text".equals($dest)) {
                this.button.setText(I18n._((String)String.valueOf(SwingUtil.getStringValue((Object)this.renderer.getText(this.getSelectedLocale())))));
            } else if ("button.toolTipText".equals($dest)) {
                this.button.setToolTipText(I18n._((String)String.valueOf(this.getTip(this.getSelectedLocale()))));
            }
        }
        finally {
            this.$activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
            this.removePropertyChangeListener(SHOW_ICON_PROPERTY, this.$DataSource2);
        } else if ("renderer.showText".equals($binding)) {
            this.removePropertyChangeListener(SHOW_TEXT_PROPERTY, this.$DataSource3);
        } else if ("button.icon".equals($binding)) {
            this.removePropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource5);
        } else if ("button.selected".equals($binding)) {
            if (this.popup != null) {
                ((JPopupMenu)this.$bindingSources.remove("popup")).removeComponentListener((ComponentListener)Util.getEventListener(ComponentListener.class, (Object)this.content, (String)"$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
            this.removePropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource7);
        } else if ("button.toolTipText".equals($binding)) {
            this.removePropertyChangeListener(SELECTED_LOCALE_PROPERTY, this.$DataSource8);
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doFocusGained__on__content(FocusEvent event) {
        this.button.requestFocus();
    }

    public void doFocusLost__on__content(FocusEvent event) {
        this.setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.setPopupVisible(true);
        } else {
            this.popupVisible = false;
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        this.button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        this.button.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        log.info(this.indexes.getSelectedValue());
    }

    public List<Object> get$activeBindings() {
        return this.$activeBindings;
    }

    public Map<String, Object> get$bindingSources() {
        return this.$bindingSources;
    }

    public JToggleButton getButton() {
        return this.button;
    }

    public I18nEditor getContent() {
        return this.content;
    }

    public JAXXButtonGroup getIndexes() {
        return this.indexes;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public String getNotSelectedToolTipText() {
        return this.notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public JLabel getPopupLabel() {
        return this.popupLabel;
    }

    public Boolean getPopupVisible() {
        return this.popupVisible;
    }

    public LocaleListCellRenderer getRenderer() {
        return this.renderer;
    }

    public Locale getSelectedLocale() {
        return this.selectedLocale;
    }

    public String getSelectedToolTipText() {
        return this.selectedToolTipText;
    }

    public Boolean getShowIcon() {
        return this.showIcon;
    }

    public Boolean getShowText() {
        return this.showText;
    }

    public Boolean isPopupVisible() {
        return this.popupVisible != null && this.popupVisible != false;
    }

    public Boolean isShowIcon() {
        return this.showIcon != null && this.showIcon != false;
    }

    public Boolean isShowText() {
        return this.showText != null && this.showText != false;
    }

    public void setLocales(List<Locale> newValue) {
        List<Locale> oldValue = this.locales;
        this.locales = newValue;
        this.firePropertyChange(LOCALES_PROPERTY, oldValue, newValue);
    }

    public void setNotSelectedToolTipText(String newValue) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        this.firePropertyChange("notSelectedToolTipText", oldValue, newValue);
    }

    public void setPopupVisible(Boolean newValue) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        this.firePropertyChange(POPUP_VISIBLE_PROPERTY, oldValue, newValue);
    }

    public void setRenderer(LocaleListCellRenderer newValue) {
        LocaleListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        this.firePropertyChange("renderer", oldValue, newValue);
    }

    public void setSelectedLocale(Locale newValue) {
        Locale oldValue = this.selectedLocale;
        this.selectedLocale = newValue;
        this.firePropertyChange(SELECTED_LOCALE_PROPERTY, oldValue, newValue);
    }

    public void setSelectedToolTipText(String newValue) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        this.firePropertyChange("selectedToolTipText", oldValue, newValue);
    }

    public void setShowIcon(Boolean newValue) {
        Boolean oldValue = this.showIcon;
        this.showIcon = newValue;
        this.firePropertyChange(SHOW_ICON_PROPERTY, oldValue, newValue);
    }

    public void setShowText(Boolean newValue) {
        Boolean oldValue = this.showText;
        this.showText = newValue;
        this.firePropertyChange(SHOW_TEXT_PROPERTY, oldValue, newValue);
    }

    public void $pr$u0(ComponentEvent event) {
        this.$DataSource6.propertyChange(null);
    }

    protected String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected Map get$previousValues() {
        return this.$previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return this.allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return this.contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToContent();
        this.addChildrenToPopup();
        this.applyDataBinding("renderer.showIcon");
        this.applyDataBinding("renderer.showText");
        this.popup.setBorder(new TitledBorder(I18n._((String)"i18neditor.popup.title")));
        this.applyDataBinding("button.icon");
        this.applyDataBinding("button.selected");
        this.applyDataBinding("button.text");
        this.applyDataBinding("button.toolTipText");
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("content", this);
        this.createSelectedToolTipText();
        this.createNotSelectedToolTipText();
        this.createShowText();
        this.createShowIcon();
        this.createPopupVisible();
        this.createLocales();
        this.createSelectedLocale();
        this.createRenderer();
        this.createPopup();
        this.createPopupLabel();
        this.createButton();
        this.createIndexes();
        this.create$ScriptInitializer0();
        this.content.setName("content");
        this.content.setLayout(new BorderLayout());
        this.content.addFocusListener((FocusListener)Util.getEventListener(FocusListener.class, (String)"focusGained", (Object)this.content, (String)"doFocusGained__on__content"));
        this.content.addFocusListener((FocusListener)Util.getEventListener(FocusListener.class, (String)"focusLost", (Object)this.content, (String)"doFocusLost__on__content"));
        this.addPropertyChangeListener(this);
        this.$completeSetup();
    }

    protected void addChildrenToContent() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.content.add((Component)this.renderer);
        this.content.add((Component)this.button, "Center");
    }

    protected void addChildrenToPopup() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.popup.add(this.popupLabel);
    }

    protected void create$ScriptInitializer0() {
        this.showPopupRunnable = new Runnable(){

            @Override
            public void run() {
                I18nEditor.this.getPopup().pack();
                Dimension dim = I18nEditor.this.getPopup().getPreferredSize();
                JToggleButton invoker = I18nEditor.this.getButton();
                I18nEditor.this.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
            }
        };
    }

    protected void createButton() {
        this.button = new JToggleButton();
        this.$objectMap.put("button", this.button);
        this.button.setName("button");
        this.button.setFocusPainted(false);
        this.button.setFocusable(true);
        this.button.addItemListener((ItemListener)Util.getEventListener(ItemListener.class, (String)"itemStateChanged", (Object)this.content, (String)"doItemStateChanged__on__button"));
    }

    protected void createIndexes() {
        this.indexes = new JAXXButtonGroup();
        this.$objectMap.put("indexes", this.indexes);
        this.indexes.addChangeListener((ChangeListener)Util.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this.content, (String)"doStateChanged__on__indexes"));
    }

    protected void createLocales() {
        this.locales = null;
        this.$objectMap.put(LOCALES_PROPERTY, this.locales);
    }

    protected void createNotSelectedToolTipText() {
        this.notSelectedToolTipText = null;
        this.$objectMap.put("notSelectedToolTipText", this.notSelectedToolTipText);
    }

    protected void createPopup() {
        this.popup = new JPopupMenu();
        this.$objectMap.put("popup", this.popup);
        this.popup.setName("popup");
        this.popup.addPopupMenuListener((PopupMenuListener)Util.getEventListener(PopupMenuListener.class, (String)"popupMenuCanceled", (Object)this.content, (String)"doPopupMenuCanceled__on__popup"));
        this.popup.addPopupMenuListener((PopupMenuListener)Util.getEventListener(PopupMenuListener.class, (String)"popupMenuWillBecomeInvisible", (Object)this.content, (String)"doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        this.popupLabel = new JLabel();
        this.$objectMap.put("popupLabel", this.popupLabel);
        this.popupLabel.setName("popupLabel");
        this.popupLabel.setEnabled(false);
        this.popupLabel.setText(I18n._((String)"i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        this.popupVisible = Boolean.FALSE;
        this.$objectMap.put(POPUP_VISIBLE_PROPERTY, this.popupVisible);
    }

    protected void createRenderer() {
        this.renderer = new LocaleListCellRenderer(this.showIcon.booleanValue(), this.showText.booleanValue());
        this.$objectMap.put("renderer", this.renderer);
        this.renderer.setName("renderer");
    }

    protected void createSelectedLocale() {
        this.selectedLocale = Locale.getDefault();
        this.$objectMap.put(SELECTED_LOCALE_PROPERTY, this.selectedLocale);
    }

    protected void createSelectedToolTipText() {
        this.selectedToolTipText = null;
        this.$objectMap.put("selectedToolTipText", this.selectedToolTipText);
    }

    protected void createShowIcon() {
        this.showIcon = Boolean.TRUE;
        this.$objectMap.put(SHOW_ICON_PROPERTY, this.showIcon);
    }

    protected void createShowText() {
        this.showText = Boolean.TRUE;
        this.$objectMap.put(SHOW_TEXT_PROPERTY, this.showText);
    }
}

