/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class JAXXButtonGroup
extends ButtonGroup {
    public static final String SELECTED_VALUE_PROPERTY = "selectedValue";
    public static final String BUTTON8GROUP_CLIENT_PROPERTY = "$buttonGroup";
    public static final String VALUE_CLIENT_PROPERTY = "$value";
    public static final String SELECTED_TIP_CLIENT_PROPERTY = "$selected.toolTipText";
    public static final String NOT_SELECTED_TIP_CLIENT_PROPERTY = "$not.selected.toolTipText";
    protected EventListenerList listenerList = new EventListenerList();
    private PropertyChangeSupport propertyChangeSupport;
    private transient Object selectedValue;
    protected boolean useToolTipText;
    protected transient ChangeEvent changeEvent = new ChangeEvent(this);
    private transient ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JAXXButtonGroup.this.updateSelectedValue();
            if (JAXXButtonGroup.this.useToolTipText) {
                JAXXButtonGroup.this.updateToolTipText();
            }
        }
    };
    private static final long serialVersionUID = 1L;

    @Override
    public void add(AbstractButton button) {
        super.add(button);
        button.addChangeListener(this.changeListener);
        this.updateSelectedValue();
    }

    @Override
    public void remove(AbstractButton button) {
        super.remove(button);
        button.removeChangeListener(this.changeListener);
        this.updateSelectedValue();
    }

    public void updateSelectedValue() {
        Enumeration<AbstractButton> e = this.getElements();
        while (e.hasMoreElements()) {
            Object buttonValue;
            AbstractButton button = e.nextElement();
            if (!button.isSelected() || (buttonValue = button.getClientProperty(VALUE_CLIENT_PROPERTY)) == this.getSelectedValue()) continue;
            this.setSelectedValue(buttonValue);
        }
    }

    public void updateToolTipText() {
        Enumeration<AbstractButton> e = this.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            String key = button.isSelected() ? SELECTED_TIP_CLIENT_PROPERTY : NOT_SELECTED_TIP_CLIENT_PROPERTY;
            button.setToolTipText((String)button.getClientProperty(key));
        }
    }

    public boolean isUseToolTipText() {
        return this.useToolTipText;
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public AbstractButton getSelectedButton() {
        Enumeration<AbstractButton> e = this.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public AbstractButton getButton(Object value) {
        Enumeration<AbstractButton> e = this.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            Object buttonValue = button.getClientProperty(VALUE_CLIENT_PROPERTY);
            if (!value.equals(buttonValue)) continue;
            return button;
        }
        return null;
    }

    public void setSelectedValue(Object value) {
        Object oldValue = this.getSelectedValue();
        this.selectedValue = value;
        this.firePropertyChange(oldValue);
    }

    public void setUseToolTipText(boolean useToolTipText) {
        this.useToolTipText = useToolTipText;
    }

    public void setSelectedButton(Object value) {
        this.setSelectedValue(value);
        if (value == null) {
            Enumeration<AbstractButton> e = this.getElements();
            while (e.hasMoreElements()) {
                AbstractButton button = e.nextElement();
                this.setSelected(button.getModel(), false);
            }
            return;
        }
        Enumeration<AbstractButton> e = this.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            Object buttonValue = button.getClientProperty(VALUE_CLIENT_PROPERTY);
            if (!value.equals(buttonValue)) continue;
            button.setSelected(true);
            break;
        }
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(property, listener);
    }

    private void firePropertyChange(Object oldValue) {
        if (this.propertyChangeSupport != null) {
            this.getPropertyChangeSupport().firePropertyChange(SELECTED_VALUE_PROPERTY, oldValue, this.getSelectedValue());
        }
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

