package jaxx.runtime;


import java.util.List;
import jaxx.runtime.validator.BeanValidator;

/**
 * The contract of a validator-able object.
 *
 * @author chemit
 */
public interface JAXXValidator {

    /**
     * Obtain a validator from his id
     *
     * @param validatorId validator id
     * @return the associated validator, or <code>null</code> if not find
     */
    BeanValidator<?> getValidator(String validatorId);

    /** @return the list of ids of all registred validator */
    List<String> getValidatorIds();

}