package jaxx.demo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;

public class Identity {

    protected String firstName = "";

    protected String lastName = "";

    protected String email = "dummy@codelutin.com";

    protected int age = 51;

    protected File config = new File("/tmp");

    protected File dir = new File("/tmp");

    PropertyChangeSupport p;

    public Identity() {
        p = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }


    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public String getEmail() {
        return email;
    }

    public int getAge() {
        return age;
    }

    public File getConfig() {
        return config;
    }

    public File getDir() {
        return dir;
    }

    public void setFirstName(String firstName) {
        String oldFirstName = this.firstName;
        this.firstName = firstName;
        p.firePropertyChange("firstName", oldFirstName, firstName);
    }

    public void setLastName(String lastName) {
        String oldLastName = this.lastName;
        this.lastName = lastName;
        p.firePropertyChange("lastName", oldLastName, lastName);
    }

    public void setEmail(String email) {
        String oldEmail = this.email;
        this.email = email;
        p.firePropertyChange("email", oldEmail, email);
    }

    public void setAge(int age) {
        int oldAge = this.age;
        this.age = age;
        p.firePropertyChange("age", oldAge, age);
    }

    public void setConfig(File config) {
        File oldConfig = this.config;
        this.config = config;
        p.firePropertyChange("config", oldConfig, config);
    }

    public void setDir(File dir) {
        File oldDir = this.dir;
        this.dir = dir;
        p.firePropertyChange("dir", oldDir, dir);
    }
}