/*
 * Decompiled with CFR 0.152.
 */
package jaxx.demo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;

public class CalculatorEngine {
    public static final String DISPLAY_TEXT_PROPERTY = "displayText";
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int RESULT = 4;
    private int operation = -1;
    private boolean clear = true;
    private String displayText = "0";
    private BigDecimal value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        String oldDisplayText = this.displayText;
        this.displayText = displayText;
        this.firePropertyChange(DISPLAY_TEXT_PROPERTY, oldDisplayText, displayText);
    }

    public void clear() {
        this.clearEntry();
        this.value = new BigDecimal(0);
        this.operation = -1;
    }

    public void clearEntry() {
        this.setDisplayText("0");
        this.clear = true;
    }

    private void checkClear() {
        if (this.clear) {
            this.setDisplayText("");
            this.clear = false;
        }
    }

    public void digit(int digit) {
        this.checkClear();
        this.setDisplayText(this.getDisplayText() + String.valueOf(digit));
    }

    public void dot() {
        this.checkClear();
        if (this.getDisplayText().indexOf(46) == -1) {
            if (this.getDisplayText().length() == 0) {
                this.setDisplayText("0.");
            } else {
                this.setDisplayText(this.getDisplayText() + '.');
            }
        }
    }

    public void toggleSign() {
        String text = this.getDisplayText();
        if (text.startsWith("-")) {
            text = text.substring(1);
        } else if (!text.equals("0")) {
            text = '-' + text;
        }
        this.setDisplayText(text);
    }

    public void equal() {
        BigDecimal displayValue;
        BigDecimal newValue = displayValue = new BigDecimal(this.getDisplayText());
        switch (this.operation) {
            case 0: {
                newValue = this.value.add(displayValue);
                break;
            }
            case 1: {
                newValue = this.value.subtract(displayValue);
                break;
            }
            case 2: {
                newValue = this.value.multiply(displayValue);
                break;
            }
            case 3: {
                newValue = this.value.divide(displayValue, 8, 4);
            }
        }
        this.value = newValue;
        this.setDisplayText(CalculatorEngine.toString(newValue));
        this.clear = true;
        this.operation = -1;
    }

    public static String toString(BigDecimal decimal) {
        String result = decimal.toString();
        if (result.indexOf(".") != -1) {
            while (result.endsWith("0")) {
                result = result.substring(0, result.length() - 1);
            }
            if (result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public void operation(int operation) {
        if (this.operation != -1) {
            this.equal();
        } else {
            this.value = new BigDecimal(this.getDisplayText());
            this.clear = true;
        }
        this.operation = operation;
    }

    public void add() {
        this.operation(0);
    }

    public void subtract() {
        this.operation(1);
    }

    public void multiply() {
        this.operation(2);
    }

    public void divide() {
        this.operation(3);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }
}

