/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoDataProvider.java 2606 2013-03-09 18:12:23Z kmorin $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.19/jaxx-demo/src/main/java/jaxx/demo/tree/DemoDataProvider.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.tree;

import jaxx.demo.component.jaxx.BoxedDecoratorDemo;
import jaxx.demo.component.jaxx.StatusMessagePanelDemo;
import jaxx.demo.component.jaxx.editor.BeanComboBoxDemo;
import jaxx.demo.component.jaxx.editor.BeanComboBoxDemoHandler;
import jaxx.demo.component.jaxx.editor.ComboEditorDemo;
import jaxx.demo.component.jaxx.editor.DatePickerDemo;
import jaxx.demo.component.jaxx.editor.FileEditorDemo;
import jaxx.demo.component.jaxx.editor.I18nEditorDemo;
import jaxx.demo.component.jaxx.editor.ListSelectorDemo;
import jaxx.demo.component.jaxx.editor.NumberEditorDemo;
import jaxx.demo.component.jaxx.editor.TimeEditorDemo;
import jaxx.demo.component.swing.HidorButtonDemo;
import jaxx.demo.component.swing.JButtonDemo;
import jaxx.demo.component.swing.JCheckBoxDemo;
import jaxx.demo.component.swing.JCheckBoxMenuItemDemo;
import jaxx.demo.component.swing.JComboBoxDemo;
import jaxx.demo.component.swing.JDialogDemo;
import jaxx.demo.component.swing.JListDemo;
import jaxx.demo.component.swing.JMenuItemDemo;
import jaxx.demo.component.swing.JPasswordFieldDemo;
import jaxx.demo.component.swing.JProgressBarDemo;
import jaxx.demo.component.swing.JRadioButtonDemo;
import jaxx.demo.component.swing.JRadioButtonMenuItemDemo;
import jaxx.demo.component.swing.JSliderDemo;
import jaxx.demo.component.swing.JSpinnerDemo;
import jaxx.demo.component.swing.JSplitPaneDemo;
import jaxx.demo.component.swing.JTextAreaDemo;
import jaxx.demo.component.swing.JTextFieldDemo;
import jaxx.demo.component.swing.JToggleButtonDemo;
import jaxx.demo.feature.databinding.BeanDataBindingDemo;
import jaxx.demo.feature.databinding.BindingExtremeDemo;
import jaxx.demo.feature.nav.NavDemo;
import jaxx.demo.feature.validation.simple.SimpleBeanValidationByListDemo;
import jaxx.demo.feature.validation.simple.SimpleBeanValidationByTableDemo;
import jaxx.demo.feature.validation.list.ListBeanValidationDemo;
import jaxx.demo.fun.CalculatorDemo;
import jaxx.demo.fun.CounterDemo;
import jaxx.demo.fun.LabelStyleDemo;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jaxx.demo.component.jaxx.editor.BeanDoubleListDemo;
import jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo;
import static org.nuiton.i18n.I18n.n_;

/**
 * Data provider of the navigation tree.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.1
 */
public class DemoDataProvider implements NavDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(DemoDataProvider.class);

    /** mapping of demo per package */
    protected Map<String, List<Object>> mapping;

    public DemoDataProvider() {

        mapping = new HashMap<String, List<Object>>();

        if (log.isDebugEnabled()) {
            log.debug("for " + this);
        }

        addMapping("jaxxdemo.tree",
                   n_("jaxxdemo.component.swing"),
                   n_("jaxxdemo.component.jaxx"),
                   n_("jaxxdemo.feature"),
                   n_("jaxxdemo.fun")
        );

        addMapping(n_("jaxxdemo.component.swing"),
                   n_("jaxxdemo.component.swing.buttons"),
                   n_("jaxxdemo.component.swing.form"),
                   n_("jaxxdemo.component.swing.layout"),
                   n_("jaxxdemo.component.swing.menu"),
                   n_("jaxxdemo.component.swing.window"),
                   JProgressBarDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.buttons"),
                   JButtonDemo.class,
                   JCheckBoxDemo.class,
                   JRadioButtonDemo.class,
                   JToggleButtonDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.form"),
                   n_("jaxxdemo.component.swing.form.text"),
                   JComboBoxDemo.class,
                   JListDemo.class,
                   JSliderDemo.class,
                   JSpinnerDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.form.text"),
                   JPasswordFieldDemo.class,
                   JTextFieldDemo.class,
                   JTextAreaDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.layout"),
                   JSplitPaneDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.menu"),
                   JMenuItemDemo.class,
                   JCheckBoxMenuItemDemo.class,
                   JRadioButtonMenuItemDemo.class
        );

        addMapping(n_("jaxxdemo.component.swing.window"),
                   JDialogDemo.class
        );

        addMapping(n_("jaxxdemo.component.jaxx"),
                   HidorButtonDemo.class,
                   n_("jaxxdemo.component.jaxx.editor"),
                   StatusMessagePanelDemo.class,
                   BoxedDecoratorDemo.class
        );

        addMapping(n_("jaxxdemo.component.jaxx.editor"),
                   TimeEditorDemo.class,
                   NumberEditorDemo.class,
                   ComboEditorDemo.class,
                   I18nEditorDemo.class,
                   DatePickerDemo.class,
                   FileEditorDemo.class,
                   ListSelectorDemo.class,
                   BeanComboBoxDemo.class,
                   BeanFilterableComboBoxDemo.class,
                   BeanDoubleListDemo.class
        );

        addMapping(n_("jaxxdemo.feature"),
                   n_("jaxxdemo.feature.databinding"),
                   n_("jaxxdemo.feature.validation"),
                   n_("jaxxdemo.feature.nav")
        );

        addMapping(n_("jaxxdemo.feature.databinding"),
                   BindingExtremeDemo.class,
                   BeanDataBindingDemo.class
        );

        addMapping(n_("jaxxdemo.feature.validation"),
                   n_("jaxxdemo.feature.simple.validation"),
                   n_("jaxxdemo.feature.list.validation")
        );

        addMapping(n_("jaxxdemo.feature.simple.validation"),
                   SimpleBeanValidationByListDemo.class,
                   SimpleBeanValidationByTableDemo.class
        );

        addMapping(n_("jaxxdemo.feature.list.validation"),
                   ListBeanValidationDemo.class
        );
        addMapping(n_("jaxxdemo.feature.nav"),
                   NavDemo.class
        );

        addMapping(n_("jaxxdemo.fun"),
                   LabelStyleDemo.class,
                   CounterDemo.class,
                   CalculatorDemo.class
        );
    }

    protected void addMapping(String packageName, Object... classes) {
        List<Object> list = Arrays.asList(classes);
        if (log.isDebugEnabled()) {
            log.debug("Adding mapping [" + packageName + "] : " + list);
        }
        mapping.put(packageName, list);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public List<Object> getImplementations(String packageName) {
        return mapping.get(packageName);
    }


}