package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JTextFieldDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TTW/TQBCdmHw0TYG2EVERrZRCEEggh3sqKLSKIEoBkR4qcmEdrxpXG3vZXVP3gvgJ/AS4c0Hixglx4MyBC+IvIMSBK2J2HTtNMVDhg23NznvzZubtq69QkAJW90gU2SL0lTeidufmzs49Z48O1CaVA+FxFQiIn5wFVh8qbhqXCi70uxreHMObG8GIBz71D6FbXZiV6oBROaRUKViZRgykbPbS41bEQ5GwpqKyWF98/2Y9d5+9tAAijup0K/V/oSad5Ltgea6CRaz0hDQZ8XdRhvD8XdR7Usc2GJHyLhnRx/AUSl0ociKQTMH547dsOAw+4goqjU06Cu4Tn7JrCi4bsS5G7EFCYct9VGB3tmmk2h5lrgZwbiiKCkqNbeIwiuClqU5jlDnTmeUUMNPodIljyi3qnqKkgInqpLk0t6ySogpqU8mpmiOARudWqFTgI3t1ChCHx9kCzk2JxYXbk4VPNpLrQ0GEGMbu+r975AEexe5YOuIOTWhOf9aqn95+edNOLJHH2mcyUw85GlfFRcCpUJ4ufTr2Q6g81twivNWHsqQMr4Ox+3KGsN74GMVhvQUNtzXcvk3kECkKpc/v3tcefTwBVhtmWUDcNtH5d3DiQ4FTCJgb8RvrRtHc/gy+57U23B7TW2oHQsGpNZcoUnc838UJX49wDMsZY0i1OOUPP6q91+vJKHIo7ewf0yfjKDyEouczz6fmfoytn3kfKlzS0A0mFs8yfU5/5/nYwivmvZrVa167D126FlevE4WX0QkVxV416KJpQv9dOjbngutJzsgBdbd8vEe+N9CpV/+XUIev/IWhhgy/AAYMEWNUBQAA";
    private static final Log log = LogFactory.getLog(JTextFieldDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField textField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JTextFieldDemo $DemoPanel0 = this;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextFieldDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JTextFieldDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JTextFieldDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JTextFieldDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JTextFieldDemo() {
        $initialize();
    }

    public JTextFieldDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JTextFieldDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JTextFieldDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, "Hello, " + textField.getText() + "!");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getTextField() {
        return textField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 property setters
        $JLabel0.setLabelFor(textField);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Your name:"));
        $JLabel0.setDisplayedMnemonic(110);
        createTextField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("Greet"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

}