package jaxx.demo.component.jaxx.widgets.datetime;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import static org.nuiton.i18n.I18n.t;

public class DateTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_DATE_EDITABLE = "editor.dateEditable";
    public static final String BINDING_EDITOR_DATE_FORMAT = "editor.dateFormat";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_LABEL = "editor.label";
    public static final String BINDING_EDITOR_TIME_EDITABLE = "editor.timeEditable";
    public static final String BINDING_RESULT_DATE_TEXT = "resultDate.text";
    public static final String BINDING_RESULT_DAY_DATE_TEXT = "resultDayDate.text";
    public static final String BINDING_RESULT_TIME_DATE_TEXT = "resultTimeDate.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXTW8bRRgem9hObLdJHCUttKDEjYpTqnU5AUpU0iSYUrmASA4VvjD2Tuwt491ld7ZZyyriJ/AT4M4FiRsnxIEzB0BC/AWEOHBFvDOzn/bE3jYiUtbreb+e552ZZ8bf/IkKroO2HmPf1xzPZMaQaA/uPXr0Qfcx6bEj4vYcw2aWg+RfLo/yHVTRo3GXoRudNg9vBuHNQ2toWyYxE9G7bVR22YgSd0AIY+jldETPdZvHkXnXtz0nzBqBUmX96u+/8l/qX3ydR8i3Ad0aUNmcFxUzWWijvKEzVINKT3CTYrMPMBzD7APeS3zskGLXfR8PyWfoc1Rqo6KNHUjGUD07ZZFDxPs2Q5XtIzK0PsQmoXcY2hNgdRjRemEKTYydGXqfMFfTMSOCyRG8nMDLO7oB2XkS2xZpiwwVhpZOKEP3LpLuIc8R51zcfhCirPFW+Jp7Bp3R5Ch3Wop8Kz3LPDX6wsLQ1dQMyKgT3KWiictR0ArFXUIPRWSbv04WEoPcuRYXSsQwtJFyPyE+axmE6umQ1VPLGWKWqMMNV9JO1aQTH3spba/xvvFWcRoHHmOWydB6qvzhgPQ+PbD8iUAW9DgO5JatifLEnGkvEjFLDDUtp6+ZHnwxM81ruuNFh7geZfzbanoCl6WFB6dbtBO5lGOXqEGxtRZaR7NyXEp5KdKsSQdOYFaey2m3ZCIHXUstP5AWLZaWeO/nOqjgeDAM67UzrUYfgUnq0NUJHeIJhfXfjbVfvv/ju1ZSfNaVrgntBFGwHcsmDjN46WWpPB4zaPMhtnc7aMklFIRXCOt1BbDjwAzgoN4qD9d4uHYfuwNIUSj9/sOPG5/8/ALKt1CZWlhvYe7/HlpiA2jbwKK6b7+9LxBVzxbhuQL/eVgdFI8sWIFofWySs813HUNvi5HGnduv7zwFh67l6IAc3RUOJwajRD8QYw3WqHOoQnrCtSgXrSa1wXMwMyyzvrPz1IeuXld0NaLWXfrpn7Xjb/fDzuaA6YvnusfdLXyMioZJDZMIYQ80WynkFdslnm7F2qxSa5RWNjsQxz3x3J/qYY6hBQYixNBrmXqhCTHzPZ6tJWjyt/tIIY3ZS785zjoVsrz2BFOP1PmsTONIym12CLezlZeSqyo7LdnZi7+Vnb+sMrMBqXNhHgjYQ4ty9xKd43E8EsF65TxIUvmVtZOHwkVqb59XO3moqRAoTr3/BUfyjFTimD5E5+GoMFSS/QMY18bJVmqGexwgbHBZWwkEeRQeJ0CBRa8LXYLhrC+NxRUL3Kuhe2AXXFCZf7TEYoEDZZxcNhoc0PxuIooVqLzpXBkntlbKo5oky9DWeJr8JIMAw6rEyLNxbI2UZr/xTJotP7hYwxkVEw44l/TwrZpcIRzs9IpJg1VNb3C7ybDHn5ONvC3Io0dRXpqzS8yN2XXEqKrQ5CUrw14KKtbHA2zqlDjR3E7MNJ+nRRLNQ+EUU1eJIXGLy0745lzCYjkot+70vTA77Uaa9miS+egZyaevn9n5vzqHf6gWqpqqG232DtxKdiDMEbcgGsneg4mrc5ZNF94LL+8BfbzZNUwdfvHcncqe48/y3Ix8+Ff++E2dYeXCGW5Bhv8AJSvx+NkQAAA=";
    private static final Log log = LogFactory.getLog(DateTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected JCheckBox dateEditableButton;
    protected DateTimeEditor editor;
    protected JCheckBox enableButton;
    protected JTextField formatConfig;
    protected JLabel formatConfigLabel;
    protected final DateTimeEditorDemoHandler handler = new DateTimeEditorDemoHandler();
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected DateTimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultDate;
    protected JLabel resultDateLabel;
    protected JTextField resultDayDate;
    protected JLabel resultDayDateLabel;
    protected JTextField resultTimeDate;
    protected JLabel resultTimeDateLabel;
    protected JCheckBox timeEditableButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateTimeEditorDemo() {
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public JCheckBox getDateEditableButton() {
        return dateEditableButton;
    }

    public DateTimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JTextField getFormatConfig() {
        return formatConfig;
    }

    public JLabel getFormatConfigLabel() {
        return formatConfigLabel;
    }

    public DateTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public DateTimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultDate() {
        return resultDate;
    }

    public JLabel getResultDateLabel() {
        return resultDateLabel;
    }

    public JTextField getResultDayDate() {
        return resultDayDate;
    }

    public JLabel getResultDayDateLabel() {
        return resultDayDateLabel;
    }

    public JTextField getResultTimeDate() {
        return resultTimeDate;
    }

    public JLabel getResultTimeDateLabel() {
        return resultTimeDateLabel;
    }

    public JCheckBox getTimeEditableButton() {
        return timeEditableButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfigLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfig, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(dateEditableButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(timeEditableButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultDateLabel);
        result.add(resultDate);
        result.add(resultDayDateLabel);
        result.add(resultDayDate);
        result.add(resultTimeDateLabel);
        result.add(resultTimeDate);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDateEditableButton() {
        $objectMap.put("dateEditableButton", dateEditableButton = new JCheckBox());
        
        dateEditableButton.setName("dateEditableButton");
        dateEditableButton.setText(t("jaxxdemo.datetimeeditor.dateEditable"));
        dateEditableButton.setSelected(true);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new DateTimeEditor(this));
        
        editor.setName("editor");
        editor.setPropertyTimeDate("timeDate");
        editor.setPropertyDate("date");
        editor.setPropertyDayDate("dayDate");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.datetimeeditor.enable"));
        enableButton.setSelected(true);
    }

    protected void createFormatConfig() {
        $objectMap.put("formatConfig", formatConfig = new JTextField());
        
        formatConfig.setName("formatConfig");
        formatConfig.setColumns(15);
    }

    protected void createFormatConfigLabel() {
        $objectMap.put("formatConfigLabel", formatConfigLabel = new JLabel());
        
        formatConfigLabel.setName("formatConfigLabel");
        formatConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.format"));
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
        labelConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DateTimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultDate() {
        $objectMap.put("resultDate", resultDate = new JTextField());
        
        resultDate.setName("resultDate");
        resultDate.setColumns(15);
        resultDate.setEditable(false);
    }

    protected void createResultDateLabel() {
        $objectMap.put("resultDateLabel", resultDateLabel = new JLabel());
        
        resultDateLabel.setName("resultDateLabel");
        resultDateLabel.setText(t("jaxxdemo.datetimeeditor.result.date"));
    }

    protected void createResultDayDate() {
        $objectMap.put("resultDayDate", resultDayDate = new JTextField());
        
        resultDayDate.setName("resultDayDate");
        resultDayDate.setColumns(15);
        resultDayDate.setEditable(false);
    }

    protected void createResultDayDateLabel() {
        $objectMap.put("resultDayDateLabel", resultDayDateLabel = new JLabel());
        
        resultDayDateLabel.setName("resultDayDateLabel");
        resultDayDateLabel.setText(t("jaxxdemo.datetimeeditor.result.dayDate"));
    }

    protected void createResultTimeDate() {
        $objectMap.put("resultTimeDate", resultTimeDate = new JTextField());
        
        resultTimeDate.setName("resultTimeDate");
        resultTimeDate.setColumns(15);
        resultTimeDate.setEditable(false);
    }

    protected void createResultTimeDateLabel() {
        $objectMap.put("resultTimeDateLabel", resultTimeDateLabel = new JLabel());
        
        resultTimeDateLabel.setName("resultTimeDateLabel");
        resultTimeDateLabel.setText(t("jaxxdemo.datetimeeditor.result.timeDate"));
    }

    protected void createTimeEditableButton() {
        $objectMap.put("timeEditableButton", timeEditableButton = new JCheckBox());
        
        timeEditableButton.setName("timeEditableButton");
        timeEditableButton.setText(t("jaxxdemo.datetimeeditor.timeEditable"));
        timeEditableButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        configPanel.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.configuration")));
        SwingUtil.setText(labelConfig, t("jaxxdemo.datetimeeditor.configuration.label.value"));
        
        SwingUtil.setText(formatConfig, t("jaxxdemo.datetimeeditor.configuration.format.value"));
        
        editor.setBean(model);
        editor.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.editor")));
        result.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createFormatConfigLabel();
        createFormatConfig();
        createDateEditableButton();
        createTimeEditableButton();
        createEnableButton();
        createEditor();
        createResult();
        createResultDateLabel();
        createResultDate();
        createResultDayDateLabel();
        createResultDayDate();
        createResultTimeDateLabel();
        createResultTimeDate();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    editor.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LABEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (labelConfig != null) {
                    $bindingSources.put("labelConfig.getDocument()", labelConfig.getDocument());
                    labelConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    labelConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (labelConfig != null) {
                    editor.setLabel(labelConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (labelConfig != null) {
                    Document $target = (Document) $bindingSources.remove("labelConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    }
                    labelConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            public void $pr$u1(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatConfig != null) {
                    $bindingSources.put("formatConfig.getDocument()", formatConfig.getDocument());
                    formatConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    formatConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatConfig != null) {
                    editor.setDateFormat(formatConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatConfig != null) {
                    Document $target = (Document) $bindingSources.remove("formatConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    }
                    formatConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            public void $pr$u2(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TIME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (timeEditableButton != null) {
                    $bindingSources.put("timeEditableButton.getModel()", timeEditableButton.getModel());
                    timeEditableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    timeEditableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_TIME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (timeEditableButton != null) {
                    editor.setTimeEditable(timeEditableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (timeEditableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("timeEditableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    timeEditableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_TIME_EDITABLE));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (dateEditableButton != null) {
                    $bindingSources.put("dateEditableButton.getModel()", dateEditableButton.getModel());
                    dateEditableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    dateEditableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (dateEditableButton != null) {
                    editor.setDateEditable(dateEditableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (dateEditableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("dateEditableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    dateEditableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_EDITABLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDate, handler.getDate(model.getDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DAY_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDayDate, handler.getDayDate(model.getDayDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TIME_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultTimeDate, handler.getTimeDate(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
    }

}