package jaxx.demo.component.jaxx.navigation;

import jaxx.demo.component.jaxx.navigation.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.demo.component.jaxx.navigation.content.*;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.DataBindingListener;

public class FullNavigationTreeDemo extends jaxx.demo.DemoPanel {
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UTU8TQRieVttaymcJBSKaisREo1vwKERRsEFSPkKJIfbidHekQ6Y768wsbDkYf4I/Qe9eTLx5Mh48e/Bi/AvGePBqfGe73aW6YhPoYdt9P5553neep6+/oZQU6NIe9jxDuLaiTWKs3t3Z2ajvEVMtE2kK6iguUPuTSKJkDeWsMC4Vulyr6PZS0F5a4k2H28Q+0j1fQX1StRiRDUKUQhe6O0wpS9UwPe85ruighqTiUF/++J58YT1/lUTIc4BdBkYp/q8rmuRsBSWppVAeTtrHJYbtXaAhqL0LfAd0bIlhKddxkzxFz1CmgtIOFgCm0HTvI/sYfr/nKJSbWSZNvoltwmYVuuWTtSBimB0Iw4/ZeJ/uYkW5bZRdxtbD121BiIZwHB80rdCAyW0FjRXc4i5wu9i1AXkA8xhLWFjt/M2oMWt1qMAO9LheUL3qB48USodRpYMKFboKq52ErhyKKM2sVk3BGdOpOYXGu5vClC7Ph1190dAKjXS16Kl11VhYnAmm1q8jAY5A57tmB10Zka6ii0/UUEq4EFZoova3FLcg1RbhxB8i1IB+9ldh9PO7r2/LHeX1w9ljsaVHjAOKcAR3iFBUHz3Ulp2rKCutYWe+BnsmDFznu2oqhlg1SAM5OM/fkKHbjRUsGwCRynx5/6Hw+NMZlCyjPsaxVca6/gHKqoaALXBmec6dRZ9R/8E5eA5rbgoVXUk2bNZ6SCWtg2ZDPcPRtvQvJL9AbUZtUsQKPFJ3FbntwYqmYlYU8qxnP/4crb5Z7KwpAbQn/1kerSr1CKXbp/kWDdwXa8mcI4lr8chlcb5L6O8BJ1D0tP+8EreHNAtMNLhgYYWLdWpbIECYVLdc80fQv677iMM9IOZhj9vcNRv3PQfbFobt6tqr8YijvXCsc2ERofNz8SiFHlAmG1zQQ7hYzNp+vIfFJmfUbJ0QeHxfC9w8bdjsE+B6Q9LD49Y32QNQqsktwo5h0wtITnCuArOckM9g2/TgsbVTIDYMJj+QW8BuBdQGf3EnYqfDs8cwmgKE3/dOWGpDCAAA";
    private static final long serialVersionUID = 1L;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JTree navigation;
    protected javax.swing.JSplitPane splitPane;
    private FullNavigationTreeDemo $DemoPanel0 = this;
    private javax.swing.JScrollPane $JScrollPane1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /* begin raw body code */
    private final FullNavigationTreeHelper helper = new FullNavigationTreeHelper();
    private final ContentUIHandler contentUIHandler = new ContentUIHandler();
    
    
    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(), "FullNavigationTreeHelper.java", "Movie.java", "People.java" };
    }
    
    private void $afterCompleteSetup() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                navigation.setSelectionInterval(0, 0);
                splitPane.resetToPreferredSizes();
            }
        });
        // expand the tree
        SwingUtil.expandTree(navigation);
        // auto-expand node when selected
        SwingUtil.addExpandOnClickListener(navigation);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public FullNavigationTreeDemo() {
        super();
        $initialize();
    }

    public FullNavigationTreeDemo(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        super.applyDataBinding($binding);
        
        processDataBinding($binding);
    }

    @Override
    public void processDataBinding(String $dest, boolean $force) {
        super.processDataBinding($dest, true);
    }

    @Override
    public void removeDataBinding(String $binding) {
        super.removeDataBinding($binding);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JTree getNavigation() {
        return navigation;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToDemoPanel();
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigation);
        // init data bindings
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigation.setModel(helper.createTreeModel(this));
        navigation.setSelectionModel(helper.createTreeHandler(this));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createContentLayout();
        createSplitPane();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createNavigation();
        createContent();
        // inline creation of $DemoPanel0
        removeDataBinding("top.name");
        setName("$DemoPanel0");
        
        setContextValue(helper);setContextValue(contentUIHandler);helper.setTree(this, navigation);log.info("decorator provider = "+getContextValue(DecoratorProvider.class));helper.createModel(this);$completeSetup();
    }

    protected void addChildrenToDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demoPanel.add(splitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane1, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    @Override
    protected void createDemoPanel() {
        super.createDemoPanel();
        demoPanel.setName("demoPanel");
        ((javax.swing.JPanel) demoPanel).setLayout(new BorderLayout());
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new javax.swing.JTree());
        navigation.setName("navigation");
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setRootVisible(false);
        navigation.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

}